<?php

namespace App\Controllers;

use System\ControladorBase;
use App\Helpers\Sesion;
use App\Helpers\Url;
use App\Modelos\Usuario;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Admin extends ControladorBase
{
	protected $usuario;

        public function __construct()
        {
                parent::__construct();
                $this->usuario = new Usuario();
        }

        public function index()
        {
                if (!Sesion::get('logueado'))
                        Url::redireccionar('/admin/login');

                $titulo='Dashboard';
                $this->view->render('admin/index',compact('titulo'));
        }

	public function login()
	{
		if (Sesion::get('logueado'))
			Url::redireccionar('/admin');

		$errores = [];

		if (isset($_POST['submit']))
		{
			$user = htmlspecialchars($_POST['usuario']);
			$pass = htmlspecialchars($_POST['clave']);

			if (password_verify($pass, 
				$this->usuario->get_hash($user)) == false)
			{
				$errores[] = "Usuario o clave incorrectas";
			}

			if (count($errores) == 0)
			{
				$datos = $this->usuario->get_data($user);
				Sesion::set('logueado',true);
				Sesion::set('id_usuario',$datos->id);
				Url::redireccionar('/admin');
			}
		}

		$titulo = 'Login';
		$this->view->render('admin/auth/login',
				compact('titulo','errores'));
	}

        public function logout()
        {
                Sesion::eliminar();
                Url::redireccionar('/admin/login');
        }

	public function reset()
	{
		if(Sesion::get('logueado'))
			Url::redireccionar('/admin');

		$errores = [];

		if (isset($_POST['submit']))
		{
			$email = (isset($_POST['email']) ?
				$_POST['email'] : null);

			if (!filter_var($email,FILTER_VALIDATE_EMAIL))
			{
				$errores[]='Ingresa un email valido';
			} else {
				if ($email!=$this->usuario->
						get_email($email))
				{
					$errores[]="Correo no encontrado";
				}
			}

			if (count($errores) == 0)
			{
				$token=md5(uniqid(rand(),true));
				$datos=['token_reset'=>$token];
				$where=['email'=>$email];
				$this->usuario->update($datos,$where);

				$mail = new PHPMailer(true);
				$mail->setFrom('noreply@tinchicus.com');
				$mail->addAddress($email);
				$mail->isHTML(true);
				$mail->Subject="Reset a tu clave";
				$mail->Body = "<p>Para cambiar tu contraseña haz click <a href='http://localhost:8000/admin/cambia_clave/$token'>en este link</a></p>";
                		$mail->AltBody = "Para cambiar tu contraseña ve a la siguiente direccion: http://localhost:8000/admin/cambia_clave/$token";
				$mail->send();

				Sesion::set('exito',"Email enviado a " . 
						htmlentities($email));
				Url::redireccionar('/admin/reset');
			}
		}

		$titulo = "Reseteo de cuenta";
		$this->view->render('admin/auth/reset', 
				compact('titulo','errores'));

	}

	public function cambia_clave($token)
	{
		if (Sesion::get('logueado'))
			Url::redireccionar('/admin');

		$errores = [];

                $usuario = $this->usuario->get_token($token);
                if ($usuario == null)
                        $errores[] = "Usuario no encontrado";

		if (isset($_POST['submit']))
		{
			$token=htmlspecialchars($_POST['token']);
			$clave=htmlspecialchars($_POST['password']);
			$clave2=htmlspecialchars($_POST['password_confirm']);

			$usuario = $this->usuario->get_token($token);

			if ($usuario == null)
				$errores[] = 'Usuario no encontrado.';

			if ($clave != $clave2)
			{
				$errores[] = 'Las claves no coinciden';
			} elseif (strlen($clave) < 3) {
				$errores[] = 'La clave es muy corta';
			}

			if (count($errores) == 0)
			{
				$datos = [
					'token_reset' => null,
					'clave' => password_hash(
						$clave, PASSWORD_BCRYPT)
					];
				$where = [
					'id' => $usuario->id,
					'token_reset' => $token
					];

				$this->usuario->update($datos, $where);

				Sesion::set('logueado', true);
				Sesion::set('id_usuario', $usuario->id);
				Sesion::set('exito', "Clave actualizada");

				Url::redireccionar('/admin');
			}
		}

		$titulo = "Cambiar contrase&ntilde;a";

		$this->view->render('admin/auth/cambia_clave',
					compact('titulo','token','errores'));
	}
}
