<?php

namespace App\Controllers;

use System\ControladorBase;
use App\Helpers\Sesion;
use App\Helpers\Url;
use App\Modelos\Usuario;

class Usuarios extends ControladorBase
{
	protected $usuario;

        public function __construct()
        {
                parent::__construct();
                if(!Sesion::get("logueado"))
                        Url::redireccionar('/admin/login');
                $this->usuario = new Usuario();
        }

        public function index()
        {
                $usuarios = $this->usuario->get_usuarios();
                $titulo = 'Usuarios';
                $this->view->render('admin/users/index',
                                compact('usuarios', 'titulo'));
        }

	public function add()
	{
		$errores = [];

		if (isset($_POST['submit']))
		{
			$user=(isset($_POST['user']) ? $_POST['user'] : null);
			$email=(isset($_POST['email']) ? 
					$_POST['email'] : null);
			$password=(isset($_POST['password']) ?
					$_POST['password'] : null);
			$password_confirm=(isset($_POST['password_confirm']) ?
					$_POST['password_confirm'] : null);
			if (strlen($user) < 3)
			{
				$errores[] = "Usuario muy corto.";
			} else {
				if ($user == $this->usuario->
						get_username($user))
				{
					$errores[]="El usuario ya existe.";
				}
			}

			if (!filter_var($email, FILTER_VALIDATE_EMAIL))
			{
				$errores[]="Ingrese un email valido.";
			} else {
				if ($email == $this->usuario->
						get_email($email))
				{
					$errores[]="El email ya existe.";
				}
			}

			if ($password != $password_confirm)
			{
				$errores[] = "Claves no coinciden";
			} elseif (strlen($password) < 3) {
				$errores[] = "La clave es muy corta.";
			}

			if (count($errores) == 0)
			{
				$datos = [
					'usuario' => $user,
					'email' => $email,
					'clave' => password_hash(
						$password, PASSWORD_BCRYPT)
					];
				$this->usuario->insert($datos);
				Sesion::set('exito','Usuario creado');
				Url::redireccionar('/usuarios');
			}
		}
		$titulo="Agregar usuario";
		$this->view->render('admin/users/add',
				compact('errores','titulo'));
	}

	public function edit($id)
	{
		if (!is_numeric($id))
			Url::redireccionar('/usuarios');

		$usuario=$this->usuario->get_usuario($id);

		if ($usuario==null)
			Url::redireccionar('/404');

		$errores = [];

		if (isset($_POST['submit']))
		{
                        $user=(isset($_POST['user']) ? $_POST['user'] : null);
                        $email=(isset($_POST['email']) ? 
                                        $_POST['email'] : null);
                        $password=(isset($_POST['password']) ?
                                        $_POST['password'] : null);
                        $password_confirm=(isset($_POST['password_confirm']) ?
                                        $_POST['password_confirm'] : null);

			if (strlen($user) < 3)
				$errores[]='Usuario muy corto';

			if (!filter_var($email, FILTER_VALIDATE_EMAIL))
				$errores[]='Ingresa un email valido';

			if ($password!=null)
			{
				if ($password!=$password_confirm)
				{
					$errores[]='Las claves no coinciden.';
				} elseif(strlen($password) < 3) {
					$errores[]='Clave muy corta.';
				}
			}

			if (count($errores) == 0)
			{
				$datos = [
					'usuario' => $user,
					'email' => $email
					];

				if ($password != null)
					$datos['clave'] = password_hash(
						$password,PASSWORD_BCRYPT);

				$where = ['id'=>$id];
				$this->usuario->update($datos, $where);
				Sesion::set('exito','Usuario modificado');
				Url::redireccionar('/usuarios');
			}
		}

		$titulo = 'Editar usuario';
		$this->view->render('admin/users/edit',
					compact('usuario','errores','titulo'));

	}

        public function delete($id)
        {
                if (!is_numeric($id))
                        Url::redireccionar('/usuarios');

                if (Sesion::get('id_usuario') == $id)
                        die('No te puedes eliminar a ti mismo!');

                $usuario=$this->usuario->get_usuario($id);

                if ($usuario == null)
                        Url::redirecionar('/404');

                $where=['id' => $usuario->id];

                $this->usuario->delete($where);

                Sesion::set('exito','Usuario eliminado');

                Url::redireccionar('/usuarios');
        }
}
