<?php 

namespace App\Helpers;
use PDO;

class Database extends PDO
{
	protected static $instancias = array();

	public static function get($config)
	{
		$tipo=$config['db_tipo'];
		$host=$config['db_host'];
		$nombre=$config['db_nombre'];
		$usuario=$config['db_usuario'];
		$clave=$config['db_clave'];

		$id="$tipo.$host.$nombre.$usuario.$clave";

		if (isset(self::$instancias[$id]))
			return self::$instancias[$id];

		$instancia = new Database("$tipo:host=$host;dbname=$nombre;"
				. "charset=utf8",
				$usuario,
				$clave);
		$instancia->setAttribute(PDO::ATTR_ERRMODE,
						PDO::ERRMODE_EXCEPTION);
		self::$instancias[$id] = $instancia;
		return $instancia;
	}

        public function raw($sql)
        {
                return $this->query($sql);
        }

	public function select($sql,
				$array = array(),
				$fetchmode = PDO::FETCH_OBJ,
				$clase = '')
	{
		if (strtolower(substr($sql,0,7)) != 'select ')
			$sql = "SELECT " . $sql;

		$stmt = $this->prepare($sql);

		foreach($array as $clave => $valor)
		{
			if (is_int($valor))
			{
				$stmt->bindValue("$clave",
					$valor, PDO::PARAM_INT);
			} else {
				$stmt->bindValue("$clave", $valor);
			}
		}

		$stmt->execute();

		if ($fetchmode == PDO::FETCH_CLASS)
		{
			return $stmt->fetchAll($fetchmode, $clase);
		} else {
			return $stmt->fetchAll($fetchmode);
		}
	}

        public function insert($tabla, $datos)
        {
                ksort($datos);

                $nombreCampos = implode(',', array_keys($datos));
                $valoresCampos = ':' . implode(', :', array_keys($datos));

                $stmt = $this->prepare("INSERT INTO $tabla ($nombreCampos)"
                                        . " VALUES ($valoresCampos)");
                foreach($datos as $clave => $valor)
                        $stmt->bindValue(":$clave", $valor);

                $stmt->execute();
                return $this->lastInsertId();
        }

	public function update($tabla, $datos, $where)
	{
		ksort($datos);

		$detallesCampo=null;
		foreach($datos as $clave => $valor)
			$detallesCampo .= "$clave = :$clave,";
		$detallesCampo=rtrim($detallesCampo, ',');

		$detallesWhere=null;
		$i = 0;
		foreach($where as $clave => $valor)
		{
			if ($i==0)
			{
				$detallesWhere .= "$clave = :$clave";
			} else {
				$detallesWhere .= " AND $clave = :$clave";
			}
			$i++;
		}
		$detallesWhere = ltrim($detallesWhere, ' AND ');

		$stmt = $this->prepare("UPDATE $tabla SET $detallesCampo"
					. " WHERE $detallesWhere");

		foreach($datos as $clave => $valor)
			$stmt->bindValue(":$clave", $valor);

		foreach($where as $clave => $valor)
			$stmt->bindValue(":$clave", $valor);

		$stmt->execute();
		return $stmt->rowCount();
	}

	public function delete($tabla, $where, $limite = 1)
	{
		ksort($where);

		$detallesWhere=null;
		$i = 0;
		foreach($where as $clave => $valor)
		{
			if ($i==0)
			{
				$detallesWhere .= "$clave = :$clave";
			} else {
				$detallesWhere .=" AND $clave = :$clave";
			}
			$i++;
		}
		$detallesWhere = ltrim($detallesWhere, ' AND ');

		if (is_numeric($limite))
			$limitauso = "LIMIT $limite";

		$query = "DELETE FROM $tabla WHERE $detallesWhere $limitauso";

		$stmt = $this->prepare("DELETE FROM $tabla " . 
					"WHERE $detallesWhere $limitauso");

		foreach($where as $clave => $valor)
		{
			$stmt->bindValue(":$clave", $valor);
		}

		$stmt->execute();
		return $stmt->rowCount();
	}

        public function truncate($tabla)
        {
                return $this->exec("TRUNCATE TABLE $tabla");
        }
}
