<?php

namespace App\Helpers;

class Sesion
{

	private static $sesionIniciada = false;

        public static function iniciar()
        {
                if (self::$sesionIniciada == false)
                {
                        session_start();
                        self::$sesionIniciada = true;
                }
        }

        public static function set($clave, $valor=false)
        {
                if (is_array($clave) && $valor==false)
                {
                        foreach($clave as $nombre => $valor)
                                $_SESSION[$nombre] = $valor;
                } else {
                        $_SESSION[$clave] = $valor;
                }
        }

        public static function quitar($clave)
        {
                $valor = $_SESSION[$clave];
                unset($_SESSION[$clave]);

                return $valor;
        }

        public static function get($clave)
        {
                if(isset($_SESSION[$clave]))
                        return $_SESSION[$clave];

                return false;
        }

        public static function mostrar()
        {
                return $_SESSION;
        }

        public static function eliminar($clave='')
        {
                if (self::$sesionIniciada==true)
                {
                        if (empty($clave))
                        {
                                session_unset();
                                session_destroy();
                        } else {
                                unset($_SESSION[$clave]);
                        }
                }
        }

}
