<?php

namespace App\Modelos;

use System\ModeloBase;

class Usuario extends ModeloBase
{
        public function get_hash($usuario)
        {
                $datos = $this->db->select('clave from usuarios ' .
                        'where usuario = :usuario', [':usuario' => $usuario]);
                return (isset($datos[0]->clave) ? $datos[0]->clave : null);
        }

        public function get_data($usuario)
        {
                $datos = $this->db->select('* from usuarios ' .
                        'where usuario = :usuario', [':usuario' => $usuario]);
                return (isset($datos[0]) ? $datos[0] : null);
        }

        public function get_email($email)
        {
                $datos = $this->db->select('email from usuarios ' .
                        'where email= :email',[':email' => $email]);
                return (isset($datos[0]->email) ? $datos[0]->email : null);
        }

        public function get_token($token)
        {
                $datos = $this->db->select('id from usuarios ' .
                        'where token_reset = :token_reset',
                        [':token_reset' => $token]);
                return (isset($datos[0]) ? $datos[0] : null);
        }

        public function get_usuarios()
        {
                return $this->db->select("* from usuarios order by usuario");
        }

        public function get_usuario($id)
        {
                $datos = $this->db->select("* from usuarios " .
                                "where id = :id", [':id' => $id]);
                return (isset($datos[0]) ? $datos[0] : null);
        }

        public function get_username($usuario)
        {
                $datos=$this->db->select("usuario from usuarios " .
                                "where usuario = :usuario",
                                [':usuario' => $usuario]);
                return (isset($data[0]->usuario) ? $datos[0]->usuario : null);
        }

        public function insert($datos)
        {
                $this->db->insert('usuarios', $datos);
        }

        public function update($datos, $where)
        {
                $this->db->update('usuarios', $datos, $where);
        }

        public function delete($where)
        {
                $this->db->delete('usuarios', $where);
        }
}
