<?php

namespace System;

use System\View;

class Route
{
	public function __construct($config)
	{
		$url = explode('/', trim($_SERVER['REQUEST_URI'],'/'));
		$cont = !empty($url[0]) ? $url[0]:$config['default_cont'];
		$metodo = !empty($url[1]) ? $url[1]:$config['default_met'];
		$args = !empty($url[2]) ? array_slice($url, 2): array();
		$clase = $config['namespace'].$cont;

		if (!class_exists($clase))
		{
			return $this->not_found();
		}

		if (!method_exists($clase, $metodo))
		{
			return $this->not_found();
		}

		$instanciaClase = new $clase;

		call_user_func_array(array($instanciaClase, $metodo), $args);
	}

	public function not_found()
	{
		$view = new View();
		return $view->render('404');
	}
}
