<?php
if(file_exists('../vendor/autoload.php')){
	require '../vendor/autoload.php';
} else {
	echo "<h1>Por favor instalalo via composer.json</h1>";
	echo "<p>Instrucciones del Composer: <a href='https://getcomposer.org/doc/00-intro.md#globally'>https://getcomposer.org/doc/00-intro.md#globally</a></p>";
	echo "<p>Una vez que se instalo ve al directorio de trabajo en tu terminal o prompt de comando e ingresa 'composer.phar install'</p>";
	exit;
}

defined('DS') || define('DS', DIRECTORY_SEPARATOR);
define('APPDIR', realpath(__DIR__.'/../app/').DS);
define('SYSTEMDIR', realpath(__DIR__.'/../system/').DS);
define('PUBLICDIR', realpath(__DIR__).DS);
define('ROOTDIR', realpath(__DIR__.'/../').DS);

define('ENTORNO', 'desarrollo');

if (defined('ENTORNO')){

	switch (ENTORNO){
		case 'desarrollo':
			error_reporting(E_ALL);
		break;

		case 'produccion':
			error_reporting(0);
		break;

		default:
			exit('El entorno no esta configurado correctamente.');
	}

}
$config = App\Config::get();

new System\Route($config);
