
enum {
	cCartasEnMazo = 48,
	cCartasEnMano = 3,
	cCartasEnPalo = 12,
	cNumJugadores = 4
};

typedef enum {
	oro = 1,
	copa,
	basto,
	espada
} Palo;

typedef enum {
	uno = 1, dos, tres, cuatro, cinco, seis,
	siete, ocho, nueve, sota, caballo, rey
} Numero;

typedef struct
{
	Palo palo;
	int valorPalo;
	Numero numero;
	int valorNumero;
} Carta;

typedef struct {
	int totalCartas;
	Carta* jugador[cCartasEnMano];
} Jugador;

void CartaAString(Carta* aCarta,char aCadenaCarta[20])
{
	switch(aCarta->numero)
	{
		case uno: strcpy(aCadenaCarta, "as "); break;
		case dos: strcpy(aCadenaCarta, "dos "); break;
		case tres: strcpy(aCadenaCarta, "tres "); break;
		case cuatro: strcpy(aCadenaCarta, "cuatro "); break;
		case cinco: strcpy(aCadenaCarta, "cinco "); break;
		case seis: strcpy(aCadenaCarta, "seis "); break;
		case siete: strcpy(aCadenaCarta, "siete "); break;
		case ocho: strcpy(aCadenaCarta, "ocho "); break;
		case nueve: strcpy(aCadenaCarta, "nueve "); break;
		case sota: strcpy(aCadenaCarta, "sota "); break;
		case caballo: strcpy(aCadenaCarta, "caballo "); break;
		case rey: strcpy(aCadenaCarta, "rey "); break;
		default: strcpy(aCadenaCarta, "??? "); break;
	}

	switch(aCarta->palo)
	{
		case oro: strcat(aCadenaCarta,"de Oro"); break;
		case copa: strcat(aCadenaCarta,"de Copas"); break;
		case basto: strcat(aCadenaCarta,"de Bastos"); break;
		case espada: strcat(aCadenaCarta,"de Espadas"); break;
		default: strcat(aCadenaCarta,"de ????"); break;
	}
}

void IniciarCarta(Carta* aCarta, Palo p, Numero n)
{
	aCarta->palo		= p;
	aCarta->valorPalo	= (int)p;
	aCarta->numero		= n;
	aCarta->valorNumero	= (int)n;
}

void MostrarCarta(Carta* aCarta)
{
	char cadenaCarta[20] = {0};
	CartaAString(aCarta, cadenaCarta);
	printf("%18s", cadenaCarta);
}

void IniciarMazo( Carta* aMazo )
{
	Numero n[]={ uno, dos, tres, cuatro, cinco, seis,
			siete, ocho, nueve, sota, caballo, rey };

	Carta* aC;

	for(int i=0; i < cCartasEnPalo; i++)
	{
		aC=&(aMazo[i + (0*cCartasEnPalo)]);
		IniciarCarta(aC, oro, n[i]);

		aC=&(aMazo[i + (1*cCartasEnPalo)]);
		IniciarCarta(aC, copa, n[i]);

		aC=&(aMazo[i + (2*cCartasEnPalo)]);
		IniciarCarta(aC, basto, n[i]);

		aC=&(aMazo[i + (3*cCartasEnPalo)]);
		IniciarCarta(aC, espada, n[i]);
	}
}

void MostrarMazo( Carta* aMazo )
{
	printf("%d cartas en el mazo\n\n", cCartasEnMazo);
	int indice = 0;

	printf("El mazo ordenado: \n");

	for(int i=0; i < cCartasEnPalo; i++)
	{
		indice=i + (0*cCartasEnPalo);
		printf(" (%2d)", indice + 1);
		MostrarCarta(&(aMazo[indice]));

                indice=i + (1*cCartasEnPalo);
                printf(" (%2d)", indice + 1);
                MostrarCarta(&(aMazo[indice]));

                indice=i + (2*cCartasEnPalo);
                printf(" (%2d)", indice + 1);
                MostrarCarta(&(aMazo[indice]));

                indice=i + (3*cCartasEnPalo);
                printf(" (%2d)", indice + 1);
                MostrarCarta(&(aMazo[indice]));

		printf("\n");
	}
	printf("\n");
}

void IniciarJugador(Jugador* aJugador)
{
	aJugador->totalCartas = 0;
	for(int i=0; i < cCartasEnMano; i++)
		aJugador->jugador[i] = NULL;
}

void AgregarCartaAJugador(Jugador* aJugador, Carta* aCarta)
{
	if(aJugador->totalCartas==cCartasEnMano) return;
	aJugador->jugador[ aJugador->totalCartas ] = aCarta;
	aJugador->totalCartas++;
}

void MostrarJugador(Jugador* aJugador, char* aCadenaJug, char* aCadenaLider)
{
	printf("%s%s\n", aCadenaLider, aCadenaJug);
	for(int i=0; i < cCartasEnMano; i++)
	{
		printf("%s", aCadenaLider);
		MostrarCarta(aJugador->jugador[i]);
		printf("\n");
	}
}

Carta* TomarCartaDelMazo(Carta aMazo[], int indice)
{
	Carta* aCarta = &aMazo[indice];
	return aCarta;
}

void MostrarTodosJugadores(Jugador* jugadores[ cNumJugadores ])
{
	MostrarJugador(jugadores[0], "Jug 1: ", "");
	MostrarJugador(jugadores[1], "Jug 2: ", "");
	MostrarJugador(jugadores[2], "Jug 3: ", "");
	MostrarJugador(jugadores[3], "Jug 4: ", "");
}
