$(document).ready(function() {
	$('table').each(function(indice) {
		var $tabla = $(this);
		$('<h3></h3>', {
			id: 'tabla-titulo-' + indice,
			'class': 'tabla-titulo',
			text: 'Tabla ' + (indice + 1),
			data: {'indice': indice},
			click: function(e) {
				e.preventDefault();
				$tabla.fadeToggle();
			},
			css: {colorBrillante: '#00ff00'}
		}).insertBefore($tabla);
	});
});

(function($) {
	var div=document.createElement('div');
	$.support.textShadow = div.style.textShadow === '';
	$.support.filter = div.style.filter === '';
	div = null;
	if ($.support.textShadow) {
		$.cssHooks.colorBrillante = {
			set: function(elem, valor) {
				if (valor == 'none') {
					elem.style.textShadow = '';
				} else {
					elem.style.textShadow='0 0 2px' + valor;
				}	
			}
		};
	} else {
		$.cssHooks.colorBrillante = {
			set: function(elem, valor) {
				if (value == 'none') {
					elem.style.filter='';
				} else {
					elem.style.zoom = 1;
					elem.style.filter =
					'progid:DXImageTransform.Microsoft' +
					'.Glow(Strength=2, Color='+ valor + ');';
				}
			}
		};
	}
})(jQuery);