var express = require('express');
var router = express.Router();

const math = require('../math');
router.get('/', function(req, res, next) {
	if (req.query.fibonum) {
		math.fiboasync(req.query.fibonum, (err, fiboval) => {
			if (err) next(err);
			else {
				res.render('fibonacci', {
					title: 'Calcular numeros fibonacci',
					fibonum: req.query.fibonum,
					fiboval: math.fibonacci(req.query.fibonum)
				});
			}
		});
	} else {
		res.render('fibonacci', {
			title: 'Calcular numeros fibonacci',
			fiboval: undefined
		});
	}
});

module.exports = router;
