var express = require('express');
var router = express.Router();
var http = require('http');
const math = require('../math');

router.get('/', function(req, res, next) {
	if (req.query.fibonum) {
		var httpreq = http.request({
			host: "localhost",
			port: process.env.SERVERPORT,
			path: `/fibonacci/${Math.floor(req.query.fibonum)}`,
			method: 'GET'
		});
		httpreq.on('response', (response) => {
			response.on('data', (chunk) => {
				var datos = JSON.parse(chunk);
				res.render('fibonacci', {
					title: "Calcular numeros fibonacci",
					fibonum: req.query.fibonum,
					fiboval: datos.result
				});
			});
			response.on('error', (err) => { next(err); });
		});
		httpreq.on('error', (err) => { next(err); });
		httpreq.end();
	} else {
		res.render('fibonacci', {
			title: 'Calcular numeros fibonacci',
			fiboval: undefined
		});
	}
});

module.exports = router;
