import { default as express } from 'express';
import { NotasMem as notas } from '../app.mjs';
export const router = express.Router();

router.get('/add', (req, res, next) => {
	res.render('editarnota', {
		title: "Agregar una nota",
		creador: true,
		clavenota: '',
		nota: undefined
	});
});

router.get('/ver', async(req, res, next) => {
	try {
	  let nota = await notas.read(req.query.clave);
	  res.render('vistanota', {
		title: nota ? nota.titulo : "",
		clavenota: req.query.clave,
		nota: nota
	  });
	} catch(err) { next(err); }
});

router.get('/editar', async(req, res, next) => {
        try {
          const nota = await notas.read(req.query.clave);
          res.render('editarnota', {
                title: nota ? ("Editando " + nota.titulo) : "Agregar nota",
		creador: false,
                clavenota: req.query.clave,
                nota: nota
          });
        } catch(err) { next(err); }
});

router.get('/borrar', async(req, res, next) => {
        try {
          let nota = await notas.read(req.query.clave);
          res.render('borrarnota', {
                title: nota ? nota.titulo : "",
                clavenota: req.query.clave,
                nota: nota
          });
        } catch(err) { next(err); }
});

router.post('/save', async (req, res, next) => {
	try {
	  let nota;
	  if (req.body.creador === "crear") {
		nota = await notas.create(req.body.clavenota,
			req.body.titulo, req.body.cuerpo);
	  } else {
		nota = await notas.update(req.body.clavenota,
			req.body.titulo, req.body.cuerpo);
	  }
	  res.redirect('/notas/ver?clave=' + req.body.clavenota);
	} catch(err) { next(err); }
});

router.post('/borrar/confirmar', async(req, res, next) => {
	try {
	  await notas.delete(req.body.clavenota);
	  res.redirect('/');
	} catch(err) { next(err); }
});
