import * as express from 'express';
import { NotasMem as notas } from '../app.mjs';
export const router = express.Router();

router.get('/', async (req, res, next) => {
        try {
                const listaclaves = await notas.listarClaves();
                const promesaClave = listaclaves.map(clave => {
                        return notas.read(clave);
                });
                const listanotas = await Promise.all(promesaClave);
                res.render('index', { title: 'Notas',
                                        listanotas: listanotas
                });
        } catch (err) {
                next(err);
        }
});
