import EventEmitter from 'events';

const _nota_clave = Symbol('clave');
const _nota_titulo = Symbol('titulo');
const _nota_cuerpo = Symbol('cuerpo');

export class Nota {
        constructor(clave, titulo, cuerpo) {
                this[_nota_clave] = clave;
                this[_nota_titulo] = titulo;
                this[_nota_cuerpo] = cuerpo;
        }

        get clave() { return this[_nota_clave]; }
        get titulo() { return this[_nota_titulo]; }
        set titulo(nuevo) { this[_nota_titulo] = nuevo; }
        get cuerpo() { return this[_nota_cuerpo]; }
        set cuerpo(nuevo) { this[_nota_cuerpo] = nuevo; }
	
	get JSON() {
		return JSON.stringify({
			clave: this.clave,
			titulo: this.titulo,
			cuerpo: this.cuerpo
		});
	}

	static desdeJSON(json) {
		const datos = JSON.parse(json);
		if (typeof datos !== 'object'
		   || !datos.hasOwnProperty('clave')
		   || typeof datos.clave !== 'string'
		   || !datos.hasOwnProperty('titulo')
		   || typeof datos.titulo !== 'string'
		   || !datos.hasOwnProperty('cuerpo')
		   || typeof datos.cuerpo !== 'string') {
			throw new Error(`No es una nota: ${json}`);
		}
		const nota = new Nota(datos.clave, datos.titulo, datos.cuerpo);
		return nota;
	}
}

export class AlmacenNotasAbs extends EventEmitter {
	static almacen() {}
        async cerrar() {}
        async create(clave, titulo, cuerpo) {}
        async read(clave) {}
        async update(clave, titulo, cuerpo) {}
        async delete(clave) {}
        async listarClaves() {}
        async contar() {}

	emitirCreado(nota) { this.emit('notacreada', nota); }
	emitirCambiado(nota) { this.emit('notacambiada', nota); }
	emitirBorrado(clave) { this.emit('notaborrada', clave); }
}
