import fs from 'fs-extra';
import path from 'path';
import util from 'util';
import { approotdir } from '../approotdir.mjs';
import { Nota, AlmacenNotasAbs } from './Notas.mjs';
import { default as DBG } from 'debug';
const debug = DBG('notas:notas-fs');
const error = DBG('notas:error-fs');

export default class AlmacenNotasFS extends AlmacenNotasAbs {
	async cerrar() {}

	async update(clave, titulo, cuerpo) {
		return crupdate(clave, titulo, cuerpo);
	}

	async create(clave, titulo, cuerpo) {
		return crupdate(clave, titulo, cuerpo);
	}

	async read(clave) {
		const notasdir = await notasDir();
		const lanota = await leerJSON(notasdir, clave);
		return lanota;
	}

	async delete(clave) {
		const notasdir = await notasDir();
		await fs.unlink(filePath(notasdir, clave));
	}

	async listarClaves() {
		const notasdir = await notasDir();
		let archivoz = await fs.readdir(notasdir);
		if (!archivoz || typeof archivoz === 'undefined')
			archivoz = [];
		const lasnotas = archivoz.map(async fname => {
			const clave = path.basename(fname, '.json');
			const lanota = await leerJSON(notasdir, clave);
			return lanota.clave;
		});
		return Promise.all(lasnotas);
	}

	async contar() {
		const notasdir = await notasDir();
		const archivoz = await fs.readdir(notasdir);
		return archivoz.length;
	}
}

async function notasDir() {
	const dir = process.env.NOTAS_FS_DIR
		|| path.join(approotdir, 'notas-fs-datos');
	await fs.ensureDir(dir);
	return dir;
}

const filePath = (notasdir, clave) => path.join(notasdir, `${clave}.json`);

async function leerJSON(notasdir, clave) {
	const leerDesde = filePath(notasdir, clave);
	const datos = await fs.readFile(leerDesde, 'utf8');
	return Nota.desdeJSON(datos);
}

async function crupdate(clave, titulo, cuerpo) {
	const notasdir = await notasDir();
	if (clave.indexOf('/') >= 0) {
		throw new Error(`clave ${clave} no puede tener '/'`);
	}
	const nota = new Nota(clave, titulo, cuerpo);
	const escribirA = filePath(notasdir, clave);
	const escribirJSON = nota.JSON;
	await fs.writeFile(escribirA, escribirJSON, 'utf8');
	return nota;
}
