import { promises as fs } from 'fs';
import { default as jsyaml } from 'js-yaml';
import Sequelize from 'sequelize';

var sequelizar;

export async function conectarDB() {
	if (typeof sequelizar === 'undefined') {
		const textoyaml = await fs.readFile(
					process.env.SEQUELIZE_CONNECT,
					'utf8');
		const params = jsyaml.safeLoad(textoyaml, 'utf8');

		if (typeof process.env.SEQUELIZE_DBNAME !== 'undefined'
				&& process.env.SEQUELIZE_DBNAME !== '') {
			params.dbname = process.env.SEQUELIZE_DBNAME;
		}
                if (typeof process.env.SEQUELIZE_DBUSER !== 'undefined'
                                && process.env.SEQUELIZE_DBUSER !== '') {
                        params.username = process.env.SEQUELIZE_DBUSER;
                }

                if (typeof process.env.SEQUELIZE_DBPASSWD !== 'undefined'
                                && process.env.SEQUELIZE_DBPASSWD !== '') {
                        params.password = process.env.SEQUELIZE_DBPASSWD;
                }

                if (typeof process.env.SEQUELIZE_DBHOST !== 'undefined'
                                && process.env.SEQUELIZE_DBHOST !== '') {
                        params.params.host = process.env.SEQUELIZE_DBHOST;
                }

                if (typeof process.env.SEQUELIZE_DBPORT !== 'undefined'
                                && process.env.SEQUELIZE_DBPORT !== '') {
                        params.params.port = process.env.SEQUELIZE_DBPORT;
                }

                if (typeof process.env.SEQUELIZE_DBDIALECT !== 'undefined'
                                && process.env.SEQUELIZE_DBDIALECT !== '') {
                        params.params.dialect = process.env.SEQUELIZE_DBDIALECT;
                }

		sequelizar = new Sequelize(params.dbname,
					params.username, params.password, { 
					dialect: params.dialect, 
					storage: params.storage,
					port: params.port,
					host: params.host
					});
		await sequelizar.authenticate();
	}
	return sequelizar;
}

export async function cerrar() {
	if (sequelizar) sequelizar.close();
	sequelizar = undefined;
}
