import { io } from '../app.mjs';
import { twtLogin } from './users.mjs';
import * as express from 'express';
// import { NotasMem as notas } from '../app.mjs';
import { AlmacenNotas as notas } from '../models/notas-almacen.mjs';
export const router = express.Router();
import { default as DBG } from 'debug';
const debug = DBG('notas:home');
const dbgerror = DBG('notas:home-error');

router.get('/', async (req, res, next) => {
        try {
		const listanotas = await getListaClaveTitulos();
                res.render('index', { title: 'Notas',
                                        listanotas: listanotas,
					twtLogin: twtLogin,
					user: req.user ? req.user : undefined
                });
        } catch (err) {
                next(err);
        }
});

async function getListaClaveTitulos() {
	const listaClave = await notas.listarClaves();
	const promesaClaves = listaClave.map(clave => notas.read(clave));
	const listanotas = await Promise.all(promesaClaves);
	return listanotas.map(nota => {
		return { clave: nota.clave, titulo: nota.titulo };
	});
};

export const emitirTituloNotas = async () => {
	const listanotas = await getListaClaveTitulos();
	io.of('/home').emit('titulonotas', { listanotas });
};

export function init() {
	io.of('/home').on('connect', socket => {
		debug('conexion socketio en /home');
	});
	notas.on('notacreada', emitirTituloNotas);
	notas.on('notacambiada', emitirTituloNotas);
	notas.on('notaborrada', emitirTituloNotas);
}
