
<pre>
     _   _           _        _____  _______      __
    | \ | |         | |      / ____|/ ____\ \    / /
    |  \| | ___   __| | ___ | |    | (___  \ \  / /
    | . ` |/ _ \ / _` |/ _ \| |     \___ \  \ \/ /
    | |\  | (_) | (_| |  __/| |____ ____) |  \  /
    |_| \_|\___/ \__,_|\___| \_____|_____/    \/     MIT License

</pre>

This project provides CSV generation, parsing, transformation and serialization
for Node.js.

It has been tested and used by a large community over the years and should be
considered reliable. It provides every option you would expect from an advanced
CSV parser and stringifier.

[![NPM](https://img.shields.io/npm/dm/csv)](https://www.npmjs.com/package/csv) [![NPM](https://img.shields.io/npm/v/csv)](https://www.npmjs.com/package/csv)

The `csv` package is itself split into 4 packages:

*   [`csv-generate`](https://csv.js.org/generate/),
    a flexible generator of CSV string and Javascript objects. 
    [![Build Status](https://secure.travis-ci.org/adaltas/node-csv-generate.svg?branch=master)][travis-csv-generate]
*   [`csv-parse`](https://csv.js.org/parse/),
    a parser converting CSV text into arrays or objects. 
    [![Build Status](https://secure.travis-ci.org/adaltas/node-csv-parse.svg?branch=master)][travis-csv-parse]
*   [`stream-transform`](https://csv.js.org/transform/),
    a transformation framework.
    [![Build Status](https://secure.travis-ci.org/adaltas/node-stream-transform.svg?branch=master)][travis-stream-transform]
*   [`csv-stringify`](https://csv.js.org/stringify/), 
    a stringifier converting records into a CSV text. 
    [![Build Status](https://secure.travis-ci.org/adaltas/node-csv-stringify.svg?branch=master)][travis-csv-stringify]

## Documentation

The full documentation for the current version is available [here](https://csv.js.org).

## Usage

Installation command is `npm install csv`.

Each package is fully compatible with the stream 2 and 3 specifications.
Also, a simple callback-based API is always provided for convenience.

## Development

This parent project doesn't have tests itself but instead delegates the
tests to its child projects.

Read the documentation of the child projects for additional information.

## Related projects

*   Pavel Kolesnikov "ya-csv": <http://github.com/koles/ya-csv>
*   Chris Williams "node-csv": <http://github.com/voodootikigod/node-csv>
*   Mat Holt "PapaParse": <https://github.com/mholt/PapaParse>

[travis]: https://travis-ci.org/
[travis-csv-generate]: http://travis-ci.org/adaltas/node-csv-generate
[travis-csv-parse]: http://travis-ci.org/adaltas/node-csv-parse
[travis-stream-transform]: http://travis-ci.org/adaltas/node-stream-transform
[travis-csv-stringify]: http://travis-ci.org/adaltas/node-csv-stringify
