import socketio from 'socket.io';
import passportSocketIo from 'passport.socketio';

import dotenv from 'dotenv/config.js';
import { default as DBG } from 'debug';
const debug = DBG('notas:debug'); 
const dbgerror = DBG('notas:error');

import { default as express } from 'express';
import { default as hbs } from 'hbs';
import * as path from 'path';
import { default as logger }  from 'morgan';
import { default as cookieParser } from 'cookie-parser';
import { default as bodyParser } from 'body-parser';
import * as http from 'http';
import { approotdir } from './approotdir.mjs';
import { normalizePort,
        onError,
        onListening,
        handle404,
        basicErrorHandler
        } from './appsupport.mjs';
import { 
	router as indexRouter,
	init as inicioHome 
	} from './routes/index.mjs';
import { 
	router as notasRouter,
	init as iniciaNotas 
	} from './routes/notas.mjs';
import { router as usersRouter, iniciaPass } from './routes/users.mjs';
import session from 'express-session';
import sessionFileStore from 'session-file-store';
const FileStore = sessionFileStore(session);
export const sesionCookie = 'notascookie.sid';
const secretoSesion = 'keyboard cat';
const almacenSesion = new FileStore({ path: "sessions" });

//import { NotasEnMemoria } from './models/notas-memoria.mjs';
import { default as rfs } from 'rotating-file-stream';
import { usarModelo as usarModeloNotas } from './models/notas-almacen.mjs';

usarModeloNotas(process.env.MODELO_NOTAS ? process.env.MODELO_NOTAS : 
		"memoria")
	.then(almacen => {
		inicioHome();
		iniciaNotas();
	})
	.catch(error => {onError({ code: 'ENOTESSTORE', error}); });

const __dirname = approotdir;

export const app = express();
export const port = normalizePort(process.env.PORT || '3000');
export const server = http.createServer(app);
//export const NotasMem = new NotasEnMemoria();

app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'hbs');
app.set('port', port);

hbs.registerPartials(path.join(__dirname, 'partials'));

app.use(logger(process.env.REQUEST_LOG_FORMAT || 'dev', {
	stream: process.env.REQUEST_LOG_FILE ?
		rfs.createStream(process.env.REQUEST_LOG_FILE, {
			size: '10M',
			interval: '1d',
			compress: 'gzip'
		})
		: process.stdout
	})
);
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(session({
        store: almacenSesion,
        secret: secretoSesion,
        resave: true,
        saveUninitialized: true,
        name: sesionCookie
}));
iniciaPass(app);

app.use(express.static(path.join(__dirname, 'public')));
app.use('/assets/vendor/bootstrap', express.static(
	path.join(__dirname, 'node_modules', 'bootstrap','dist')));
app.use('/assets/vendor/jquery', express.static(
	path.join(__dirname, 'node_modules', 'jquery', 'dist')));
app.use('/assets/vendor/popper.js', express.static(
	path.join(__dirname, 'node_modules', 'popper.js', 'dist', 'umd')));
app.use('/assets/vendor/feather-icons', express.static(
	path.join(__dirname, 'node_modules', 'feather-icons', 'dist')));
app.use('/assets/vendor/twitter', express.static(
	path.join(__dirname, 'public', 'assets', 'images', 'twitter')));

app.use('/', indexRouter);
app.use('/notas', notasRouter);
app.use('/users', usersRouter);
app.use(handle404);
app.use(basicErrorHandler);


server.listen(port);
server.on('error', onError);
server.on('listening', onListening);

export const io = socketio(server);

io.use(passportSocketIo.authorize({
	cookieParser: cookieParser,
	key: sesionCookie,
	secret: secretoSesion,
	store: almacenSesion
}));

server.on('request', (req, res) => {
  debug(`${new Date().toISOString()} request ${req.method} ${req.url}`);
});
