import Sequelize from 'sequelize';
import {
        conectarDB as conectarSequlz,
        cerrar as cerrarSequlz
        } from './sequelizar.mjs';

import EventEmitter from 'events';
class EmisorMensajes extends EventEmitter {}
export const emisor = new EmisorMensajes();
import DBG from 'debug';
const debug = DBG('notas:modelo-mensajes');
const error = DBG('notas:error-mensajes');

let sequelizar;
export class SQMensaje extends Sequelize.Model {}

async function conectarDB() {
        if (sequelizar) return;
        sequelizar = await conectarSequlz();
        SQMensaje.init({
                id: { type: Sequelize.INTEGER, autoIncrement: true,
                                primaryKey: true },
                de: Sequelize.STRING,
                namespace: Sequelize.STRING,
                room: Sequelize.STRING,
                mensaje: Sequelize.STRING(1024),
                fecha: Sequelize.DATE
        }, {
                hooks: {
                        afterCreate: (mensaje, opciones) => {
                                const aemitir = limpiarMensaje(mensaje);
                                emisor.emit('nuevomensaje', aemitir);
                        },
                        afterDestroy: (mensaje, opciones) => {
                                emisor.emit('destruirmensaje', {
                                        id: mensaje.id,
                                        namespace: mensaje.namespace,
                                        room: mensaje.room
                                });
                        }
                }, 
                sequelize: sequelizar,
                modelName: 'SQMensaje'
		
        });
        await SQMensaje.sync();
}

function limpiarMensaje(msj) {
	return {
		id: msj.id,
		de: msj.de,
		namespace: msj.namespace,
		room: msj.room,
		mensaje: msj.mensaje,
		fecha: msj.timestamp
	};
}

export async function postear(desde, namespace, room, mensaje) {
	await conectarDB();
	const nuevo = await SQMensaje.create({
		de: desde, 
		namespace: namespace, 
		room: room, 
		mensaje: mensaje, 
		fecha: new Date()
	});
}

export async function borrar(id) {
	await conectarDB();
	const msj = await SQMensaje.findOne({ where: { id }});
	if (msj) { msj.destroy(); }
}

export async function recientes(namespace, room) {
	await conectarDB();
	const mensajes = await SQMensaje.findAll({
		where: { namespace, room },
		order: [ ['fecha', 'DESC'] ],
		limit: 20
	});
	const msj = mensajes.map(mensaje => {
		return limpiarMensaje(mensaje);
	});
	return (msj && msj.length >= 1) ? msj : undefined;
}
