import { default as DBG } from 'debug';
const debug = DBG('notas:notas-almacen');
const error = DBG('notas:error-almacen');

var _AlmacenNotas;

export async function usarModelo(modelo) {
	try {
	  let ModuloNotasAlmac = await import(`./notas-${modelo}.mjs`);
	  let ClaseNotasAlmac = ModuloNotasAlmac.default;
	  _AlmacenNotas = new ClaseNotasAlmac();
	  return _AlmacenNotas;
	} catch(err) {
	  throw new Error(`No encuentro AlmacenNotas en ${modelo} porque ${err}`);
	}
}

export { _AlmacenNotas as AlmacenNotas };
