import { Nota, AlmacenNotasAbs } from './Notas.mjs';

const notas = [];

export default class NotasEnMemoria extends AlmacenNotasAbs {
        async cerrar() {}

        async create(clave, titulo, cuerpo) {
                notas[clave] = new Nota(clave, titulo, cuerpo);
                return notas[clave];
        }

        async read(clave) {
                if (notas[clave]) return notas[clave];
                else throw new error(`Nota ${clave} no existe`);
        }

        async update(clave, titulo, cuerpo) {
                notas[clave] = new Nota(clave, titulo, cuerpo);
                return notas[clave];
        }

        async delete(clave) {
                if (notas[clave]) {
                        delete notas[clave];
                } else {
                        throw new error(`Nota ${clave} no existe`);
                }
        }

        async listarClaves() {
                return Object.keys(notas);
        }

        async contar() {
                return notas.length;
        }
}
