import { Nota, AlmacenNotasAbs } from './Notas.mjs';
import Sequelize from 'sequelize';
import { conectarDB as conectarSequlz,
	cerrar as cerrarSequlz } from './sequelizar.mjs';

import DBG from 'debug';
const debug = DBG('notas:notas-sequelizar');
const error = DBG('notas:error-sequelizar');

var sequelizar;
export class SQNota extends Sequelize.Model {}

async function conectarDB() {
	if (sequelizar) return;
	sequelizar = await conectarSequlz();
	SQNota.init({
		clave: { type: Sequelize.DataTypes.STRING,
			primaryKey: true, 
			unique: true },
		titulo: Sequelize.DataTypes.STRING,
		cuerpo: Sequelize.DataTypes.TEXT
		}, {
		sequelize: sequelizar,
		modelName: 'SQNota'
	});
	await SQNota.sync();
}

export default class AlmacenNotasSequlz extends AlmacenNotasAbs {
	async cerrar() {
		cerrarSequlz();
		sequelizar = undefined;
	}

	async update(clave, titulo, cuerpo) {
		await conectarDB();
		const nota = await SQNota.findOne({ where: {clave: clave}});
		if (!nota) {
			throw new Error(`Nota no encontrada para ${clave}`);
		} else {
			await SQNota.update({ 
				titulo: titulo, 
				cuerpo: cuerpo },
				{ where: { clave: clave }});
			const nota = await this.read(clave);
			this.emitirCambiado(nota);
			return nota;
		}
	}

	async create(clave, titulo, cuerpo) {
		await conectarDB();
		const sqnota = await SQNota.create({
			clave: clave, 
			titulo: titulo, 
			cuerpo: cuerpo });
		const nota = new Nota(sqnota.clave, 
					sqnota.titulo, 
					sqnota.cuerpo);
		this.emitirCreado(nota);
		return nota;
	}

        async read(clave) {
                await conectarDB();
                const nota = await SQNota.findOne({ where: {clave: clave}});
                if (!nota) {
                        throw new Error(`Nota no encontrada para ${clave}`);
                }
                return new Nota(nota.clave, nota.titulo, nota.cuerpo);
        }

	async delete(clave) {
		await conectarDB();
		await SQNota.destroy({ where: { clave: clave }});
		debug(`DESTROY ${clave}`);
		this.emitirBorrado(clave);
	}

	async listarClaves() {
		await conectarDB();
		const notas = await SQNota.findAll({ 
			attributes: [ 'clave' ] });
		const claves = notas.map(nota => nota.clave);
		return claves;
	}

	async contar() {
		await conectarDB();
		const contar = await SQNota.count();
		return contar;
	}
}
