import { default as bcrypt } from 'bcrypt';
const saltRounds = 10;
import { default as request } from 'superagent';
import util from 'util';
import url from 'url';
const URL = url.URL;
import DBG from 'debug';
const debug = DBG('notas:users-admin');
const error = DBG('notas:users-error');

var idauten = 'them';
var codigoaut = 'D4ED43C0-8BD6-4FE2-B358-7C0E230D11EF';

async function hashClave(clave) {
	let salt = await bcrypt.getSalt(saltRounds);
	let hasheado = await bcrypt.hash(clave, salt);
	return hasheado;
}

function reqURL(path) {
        const requrl = new URL(process.env.URL_SERVICIO_USER);
        requrl.pathname = path;
        return requrl.toString();
}

export async function crear(usuario, clave, proveedor,
                        apellido, nombre, email, foto) {
        var res = await request
                .post(reqURL('/crear'))
                .send({ usuario, clave: await hashClave(clave), proveedor,
                        apellido, nombre, email, foto})
                .set('Content-Type', 'application/json')
                .set('Accept', 'application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

export async function cambiar(usuario, clave, proveedor,
                        apellido, nombre, email, foto) {
        var res = await request
                .post(reqURL(`/cambiar/${usuario}`))
                .send({ usuario, clave: await hashClave(clave), proveedor,
                        apellido, nombre, email, foto })
                .set('Content-Type', 'application/json')
                .set('Accept', 'application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

export async function buscar(usuario) {
        var res = await request
                .get(reqURL(`/buscar/${usuario}`))
                .set('Content-Type', 'application/json')
                .set('Accept', 'application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

export async function chequeaClave(usuario, clave) {
        var res = await request
                .post(reqURL(`/chequear`))
                .send({ usuario, clave })
                .set('Content-Type', 'application/json')
                .set('Accept', 'application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

export async function buscarCrear(perfil) {
        var res = await request
                .post(reqURL('/buscar-o-crear'))
                .send({
                        usuario: perfil.id,
                        clave: await hashClave(perfil.clave),
                        proveedor: perfil.proveedor,
                        apellido: perfil.apellido,
                        nombre: perfil.nombre,
                        email: perfil.email,
                        foto: perfil.foto
                })
                .set('Content-Type', 'application/json')
                .set('Accept', 'application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

export async function listar() {
        var res = await request
                .get(reqURL('/listar'))
                .set('Content-Type','application/json')
                .set('Accept','application/json')
                .auth(idauten, codigoaut);
        return res.body;
}

