import { postear, borrar,
	recientes, 
	emisor as EventosMsj } from '../models/mensajes-sequelz.mjs';
import DBG from 'debug';
const debug = DBG('notas:home');
const error = DBG('notas:error-home');
import { emitirTituloNotas } from './index.mjs';
import { io } from '../app.mjs';
import { twtLogin }  from './users.mjs';
import { validaAutenticado } from './users.mjs';
import { default as express } from 'express';
// import { NotasMem as notas } from '../app.mjs';
import { AlmacenNotas as notas } from '../models/notas-almacen.mjs';
export const router = express.Router();


router.get('/add', validaAutenticado, (req, res, next) => {
	res.render('editarnota', {
		title: "Agregar una nota",
		creador: true,
		clavenota: '',
		user: req.user,
		twtLogin: twtLogin,
		nota: undefined
	});
});

router.get('/ver', async(req, res, next) => {
	try {
	  let nota = await notas.read(req.query.clave);
	  const mensajes = await recientes('/notas', req.query.clave);
	  res.render('vistanota', {
		title: nota ? nota.titulo : "",
		clavenota: req.query.clave,
		nota: nota,
		mensajes,
		twtLogin: twtLogin,
		user: req.user ? req.user : undefined
	  });
	} catch(err) { next(err); }
});

router.get('/editar', validaAutenticado, async(req, res, next) => {
        try {
          const nota = await notas.read(req.query.clave);
          res.render('editarnota', {
                title: nota ? ("Editando " + nota.titulo) : "Agregar nota",
		creador: false,
                clavenota: req.query.clave,
                nota: nota,
		twtLogin: twtLogin,
		user: req.user
          });
        } catch(err) { next(err); }
});

router.get('/borrar', validaAutenticado, async(req, res, next) => {
        try {
          let nota = await notas.read(req.query.clave);
          res.render('borrarnota', {
                title: nota ? `Borrar ${nota.titulo}` : "",
                clavenota: req.query.clave,
                nota: nota,
		twtLogin: twtLogin,
		user: req.user
          });
        } catch(err) { next(err); }
});

router.post('/save', validaAutenticado, async (req, res, next) => {
	try {
	  let nota;
	  if (req.body.creador === "crear") {
		nota = await notas.create(req.body.clavenota,
			req.body.titulo, req.body.cuerpo);
	  } else {
		nota = await notas.update(req.body.clavenota,
			req.body.titulo, req.body.cuerpo);
	  }
	  res.redirect('/notas/ver?clave=' + req.body.clavenota);
	} catch(err) { next(err); }
});

router.post('/borrar/confirmar', validaAutenticado, async(req, res, next) => {
	try {
	  await notas.delete(req.body.clavenota);
	  res.redirect('/');
	} catch(err) { next(err); }
});

export function init()
{
	io.of('/notas').on('connect', async socket => {
		let clavenota = socket.handshake.query.clave;
		if (clavenota) {
			socket.join(clavenota);
			socket.on('crear-msj', async(nuevo, fn) => {
				try {
				  await postear( nuevo.de,
						nuevo.namespace,
						nuevo.room,
						nuevo.mensaje);
				  fn('ok');
				} catch(err) {
				  error(`Error al crearlo ${err.stack}`);
				}
			});
			socket.on('borrar-msj', async (datos) => {
				try {
				  await borrar(datos.id);
				} catch(err) {
				 error(`Error al borrarlo ${err.stack}`);
				}
			});
		}
	});

	notas.on('notacambiada', nota => {
		const aemitir = {
			clave: nota.clave,
			titulo: nota.titulo,
			cuerpo: nota.cuerpo
		};
		io.of('/notas').to(nota.clave).emit('notacambiada', aemitir);
		emitirTituloNotas();
	});
	notas.on('notaborrada', clave => {
		io.of('/notas').to(clave).emit('notaborrada', clave);
		emitirTituloNotas();
	});
	EventosMsj.on('nuevomensaje', nuevo => {
		io.of(nuevo.namespace).to(nuevo.room)
			.emit('nuevomensaje', nuevo);
	});
	EventosMsj.on('destruirmensaje', datos => {
		io.of(datos.namespace).to(datos.room)
			.emit('destruirmensaje', datos);
	});
}
