'use strict'
const http = require('http');
const restify = require('../');
const restifyClients = require('restify-clients');

const seenSockets = new WeakMap();

function patchEmitter(name, emitter) {
    const realEmit = emitter.emit;

    emitter.emit = function() {
        console.log(name, Array.from(arguments));
        realEmit.apply(emitter, arguments);
    }
}

const requestListener = function (req, res) {
    if (seenSockets.has(req.socket)) {
        console.log('\n ---reused socket---');
    } else {
        console.log('\n ---new socket---');
        patchEmitter('req.socket', req.socket);
    }
    seenSockets.set(req.socket, 1);

    patchEmitter('request', req);
    patchEmitter('response', res);
    req.on('data', () => {});
    const timer = setTimeout(console.log, 500, ' ---cancel request---');

    req.once('end', () => {
        res.end();
        clearTimeout(timer);
    });
}


const server = http.createServer(requestListener);
server.listen(8080);



