import { default as bcrypt } from 'bcrypt';
import restify from 'restify';
import * as util from 'util';
import { SQUser, conectarDB, paramsUser, encuentraUser,
	crearUser, clarificaUser } from './users-sequelizar.mjs';
import DBG from 'debug';
const log = DBG('users:service');
const error = DBG('users:error');

var server = restify.createServer({
	name: "user-auth-server",
	version: "0.0.1"
});

server.use(restify.plugins.authorizationParser());
server.use(chequear);
server.use(restify.plugins.queryParser());
server.use(restify.plugins.bodyParser({
	mapParams: true
}));

server.listen(process.env.PORT, "127.0.0.1", function() {
	log(server.name + ' escuchando en ' + server.url);
});

process.on('uncaughtException', function(err) {
	console.error("EXCEPCION SIN CAPTURAR - " + (err.stack || err));
	process.exit(1);
});

process.on('unhandledRejection', (reason, p) => {
	console.error(
		`RECHAZO DE PROMESA: ${util.inspect(p)} razon: ${reason}`);
	process.exit(1);
});

var apiClaves = [{ usuario: 'them', 
	clave:'D4ED43C0-8BD6-4FE2-B358-7C0E230D11EF'}];

function chequear(req, res, next) {
	if (req.authorization && req.authorization.basic) {
		var existe = false;
		for (let auth of apiClaves) {
			if (auth.clave === req.authorization.basic.password
			&& auth.usuario === req.authorization.basic.username) {
				existe = true;
				break;
			}
		}
		if (existe) next();
		else {
			res.send(401, new Error("No valido"));
			next(false);
		}
	} else {
		res.send(500, new Error("Sin clave de autorizacion"));
		next(false);
	}
}

server.post('/crear', async (req, res, next) => {
	try {
		await conectarDB();
		let resultado = await crearUser(req);
		res.contentType = 'json';
		res.send(resultado);
		next(false);
	} catch (err) {
		res.send(500, err);
		next(false);
	}
});

server.post('/buscar-o-crear', async (req, res, next) => {
	try {
		await conectarDB();
		let usuario = await encuentraUser(req.params.usuario);
		if (!usuario) {
			usuario = await crearUser(req);
			if (!usuario)
				throw new Error('Usuario no creado');
		}
		res.contentType = 'json';
		res.send(usuario);
		return next(false);
	} catch(err) {
		res.send(500, err);
		next(false);
	}
});

server.get('/buscar/:username', async (req, res, next) => {
	try {
		await conectarDB();
		const usuario = await encuentraUser(req.params.username);
		if (!usuario) {
			res.send(404,
				new Error("No encontado " + 
					req.params.username));
		} else {
			res.contentType = 'json';
			res.send(usuario);
		}
		next(false);
	} catch(err) {
		res.send(500, err);
		next(false);
	}
});

server.get('/listar', async (req, res, next) => {
	try {
		await conectarDB();
		let lista = await SQUser.findAll({});
		lista = lista.map(usuario => clarificaUser(usuario));
		if (!lista) lista = [];
		res.contentType = 'json';
		res.send(lista);
		next(false);
	} catch (err) {
		res.send(500, err);
		next(false);
	}
});

server.post('/cambiar/:username', async (req, res, next) => {
	try {
		await conectarDB();
		let acambiar = paramsUser(req);
		await SQUser.update(acambiar, { where: { usuario:
			req.params.username }});
		const resultado = await encuentraUser(req.params.username);
		res.contentType='json';
		res.send(resultado);
		next(false);
	} catch (err) {
		res.send(500, err);
		next(false);
	}
});

server.del('/borrar/:username', async (req, res, next) => {
	try {
		await conectarDB();
		const usuario = await SQUser.findOne({
			where: { usuario: req.params.username }});
		if (!usuario) {
			res.send(404,
			  new Error(`${req.params.username} no encontrado`));
		} else {
			usuario.destroy();
			res.contentType = 'json';
			res.send(req.params.username);
		}
		next(false);
	} catch(err) {
		res.send(500, err);
		next(false);
	}
});

server.post('/chequear', async (req, res, next) => {
	try {
		await conectarDB();
		const usuario = await SQUser.findOne({
			where: { usuario: req.params.usuario }});
		let existe;
		if (!usuario) {
			existe = {
				check: false, 
				usuario: req.params.usuario,
				message: "Usuario no encontrado"
			};
		} else {
			let chkpwd = false;
			if (usuario.usuario === req.params.usuario) {
				chkpwd = await bcrypt.compare(req.params.clave,
							usuario.clave);
			}
			if (chkpwd) {
				existe = { check: true, 
					usuario: usuario.usuario };
			} else {
				existe = { check: false,
					usuario: req.params.usuario,
					message: "Clave o usuario incorrecto" };
			}
		}
		res.contentType = 'json';
		res.send(existe);
		next(false);
	} catch (err) {
		res.send(500, err);
		next(false);
	}
});
