function tieneValorSinEspacio(valor: string): boolean {
	if (valor && valor.length > 0 && valor.trim().length > 0) {
		return true;
	}
	return false;
}

function usandoTest<T> (valores: T[], func: Function) {
	for(let valor of valores) {
		func.apply(Object, [valor]);
	}
}

usandoTest(
	[
	  [undefined, false],
	  [null, false],
	  [" ", false],
	  ["  ", false],
	  [" a ", true]
	],
	([valor, esValido]: [string, boolean]) => {
		it(valor + " tieneValorSinEspacio ? " + esValido,
		  () => {
		    esValido ?
		    expect(tieneValorSinEspacio(valor)).toBeTruthy() :
		    expect(tieneValorSinEspacio(valor)).toBeFalsy();
		  }
		);
	}
);
