/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { NoopAnimationStyleNormalizer } from './dsl/style_normalization/animation_style_normalizer';
import { WebAnimationsStyleNormalizer } from './dsl/style_normalization/web_animations_style_normalizer';
import { NoopAnimationDriver } from './render/animation_driver';
import { AnimationEngine } from './render/animation_engine_next';
import { WebAnimationsDriver } from './render/web_animations/web_animations_driver';
export function createEngine(type, doc) {
    // TODO: find a way to make this tree shakable.
    if (type === 'noop') {
        return new AnimationEngine(doc, new NoopAnimationDriver(), new NoopAnimationStyleNormalizer());
    }
    return new AnimationEngine(doc, new WebAnimationsDriver(), new WebAnimationsStyleNormalizer());
}
//# sourceMappingURL=data:application/json;base64,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