"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateToV18 = updateToV18;
const target_version_1 = require("../update-tool/target-version");
const upgrade_data_1 = require("./upgrade-data");
const devkit_migration_rule_1 = require("./devkit-migration-rule");
const cdkMigrations = [];
/** Entry point for the migration schematics with target of Angular CDK 18.0.0 */
function updateToV18() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V18, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
/** Function that will be called when the migration completed. */
function onMigrationComplete(context, targetVersion, hasFailures) {
    context.logger.info('');
    context.logger.info(`  ✓  Updated Angular CDK to ${targetVersion}`);
    context.logger.info('');
    if (hasFailures) {
        context.logger.warn('  ⚠  Some issues were detected but could not be fixed automatically. Please check the ' +
            'output above and fix these issues manually.');
    }
}
//# sourceMappingURL=data:application/json;base64,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