"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.cdkUpgradeData = void 0;
exports.getVersionUpgradeData = getVersionUpgradeData;
const version_changes_1 = require("../update-tool/version-changes");
const data_1 = require("./data");
/** Upgrade data for the Angular CDK. */
exports.cdkUpgradeData = {
    attributeSelectors: data_1.attributeSelectors,
    classNames: data_1.classNames,
    constructorChecks: data_1.constructorChecks,
    cssSelectors: data_1.cssSelectors,
    cssTokens: data_1.cssTokens,
    elementSelectors: data_1.elementSelectors,
    inputNames: data_1.inputNames,
    methodCallChecks: data_1.methodCallChecks,
    outputNames: data_1.outputNames,
    propertyNames: data_1.propertyNames,
    symbolRemoval: data_1.symbolRemoval,
};
/**
 * Gets the reduced upgrade data for the specified data key. The function reads out the
 * target version and upgrade data object from the migration and resolves the specified
 * data portion that is specifically tied to the target version.
 */
function getVersionUpgradeData(migration, dataName) {
    if (migration.targetVersion === null) {
        return [];
    }
    // Note that below we need to cast to `unknown` first TS doesn't infer the type of T correctly.
    return (0, version_changes_1.getChangesForTarget)(migration.targetVersion, migration.upgradeData[dataName]);
}
//# sourceMappingURL=data:application/json;base64,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