"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatDiagnostics = formatDiagnostics;
const ts = require("typescript");
const virtual_host_1 = require("./virtual-host");
/** Formats the specified diagnostics with respect to the given file system. */
function formatDiagnostics(diagnostics, fileSystem) {
    const formatHost = (0, virtual_host_1.createFormatDiagnosticHost)(fileSystem);
    return ts.formatDiagnosticsWithColorAndContext(diagnostics, formatHost);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlhZ25vc3RpY3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9zcmMvY2RrL3NjaGVtYXRpY3MvdXBkYXRlLXRvb2wvdXRpbHMvZGlhZ25vc3RpY3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7QUFPSCw4Q0FHQztBQVJELGlDQUFpQztBQUVqQyxpREFBMEQ7QUFFMUQsK0VBQStFO0FBQy9FLFNBQWdCLGlCQUFpQixDQUFDLFdBQTRCLEVBQUUsVUFBc0I7SUFDcEYsTUFBTSxVQUFVLEdBQUcsSUFBQSx5Q0FBMEIsRUFBQyxVQUFVLENBQUMsQ0FBQztJQUMxRCxPQUFPLEVBQUUsQ0FBQyxvQ0FBb0MsQ0FBQyxXQUFXLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDMUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQgKiBhcyB0cyBmcm9tICd0eXBlc2NyaXB0JztcbmltcG9ydCB7RmlsZVN5c3RlbX0gZnJvbSAnLi4vZmlsZS1zeXN0ZW0nO1xuaW1wb3J0IHtjcmVhdGVGb3JtYXREaWFnbm9zdGljSG9zdH0gZnJvbSAnLi92aXJ0dWFsLWhvc3QnO1xuXG4vKiogRm9ybWF0cyB0aGUgc3BlY2lmaWVkIGRpYWdub3N0aWNzIHdpdGggcmVzcGVjdCB0byB0aGUgZ2l2ZW4gZmlsZSBzeXN0ZW0uICovXG5leHBvcnQgZnVuY3Rpb24gZm9ybWF0RGlhZ25vc3RpY3MoZGlhZ25vc3RpY3M6IHRzLkRpYWdub3N0aWNbXSwgZmlsZVN5c3RlbTogRmlsZVN5c3RlbSk6IHN0cmluZyB7XG4gIGNvbnN0IGZvcm1hdEhvc3QgPSBjcmVhdGVGb3JtYXREaWFnbm9zdGljSG9zdChmaWxlU3lzdGVtKTtcbiAgcmV0dXJuIHRzLmZvcm1hdERpYWdub3N0aWNzV2l0aENvbG9yQW5kQ29udGV4dChkaWFnbm9zdGljcywgZm9ybWF0SG9zdCk7XG59XG4iXX0=