/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpContext, HttpContextToken } from './src/context';
export { FetchBackend } from './src/fetch';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS, HttpInterceptorHandler as ɵHttpInterceptorHandler, HttpInterceptorHandler as ɵHttpInterceptingHandler, } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule } from './src/module';
export { HttpParams, HttpUrlEncodingCodec, } from './src/params';
export { HttpFeatureKind, provideHttpClient, withFetch, withInterceptors, withInterceptorsFromDi, withJsonpSupport, withNoXsrfProtection, withRequestsMadeViaParent, withXsrfConfiguration, } from './src/provider';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase, HttpStatusCode, } from './src/response';
export { withHttpTransferCache as ɵwithHttpTransferCache, HTTP_TRANSFER_CACHE_ORIGIN_MAP, } from './src/transfer_cache';
export { HttpXhrBackend } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
// Private exports
export * from './src/private_export';
//# sourceMappingURL=data:application/json;base64,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