/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point for all public APIs of the common package.
 */
export * from './private_export';
export * from './location/index';
export { formatDate } from './i18n/format_date';
export { formatCurrency, formatNumber, formatPercent } from './i18n/format_number';
export { NgLocaleLocalization, NgLocalization } from './i18n/localization';
export { registerLocaleData } from './i18n/locale_data';
export { Plural, NumberFormatStyle, FormStyle, TranslationWidth, FormatWidth, NumberSymbol, WeekDay, getNumberOfCurrencyDigits, getCurrencySymbol, getLocaleDayPeriods, getLocaleDayNames, getLocaleMonthNames, getLocaleId, getLocaleEraNames, getLocaleWeekEndRange, getLocaleFirstDayOfWeek, getLocaleDateFormat, getLocaleDateTimeFormat, getLocaleExtraDayPeriodRules, getLocaleExtraDayPeriods, getLocalePluralCase, getLocaleTimeFormat, getLocaleNumberSymbol, getLocaleNumberFormat, getLocaleCurrencyCode, getLocaleCurrencyName, getLocaleCurrencySymbol, getLocaleDirection, } from './i18n/locale_data_api';
export { parseCookieValue as ɵparseCookieValue } from './cookie';
export { CommonModule } from './common_module';
export { NgClass, NgFor, NgForOf, NgForOfContext, NgIf, NgIfContext, NgPlural, NgPluralCase, NgStyle, NgSwitch, NgSwitchCase, NgSwitchDefault, NgTemplateOutlet, NgComponentOutlet, } from './directives/index';
export { DOCUMENT } from './dom_tokens';
export { AsyncPipe, DatePipe, DATE_PIPE_DEFAULT_TIMEZONE, DATE_PIPE_DEFAULT_OPTIONS, I18nPluralPipe, I18nSelectPipe, JsonPipe, LowerCasePipe, CurrencyPipe, DecimalPipe, PercentPipe, SlicePipe, UpperCasePipe, TitleCasePipe, KeyValuePipe, } from './pipes/index';
export { PLATFORM_BROWSER_ID as ɵPLATFORM_BROWSER_ID, PLATFORM_SERVER_ID as ɵPLATFORM_SERVER_ID, isPlatformBrowser, isPlatformServer, } from './platform_id';
export { VERSION } from './version';
export { ViewportScroller, NullViewportScroller as ɵNullViewportScroller } from './viewport_scroller';
export { XhrFactory } from './xhr';
export { IMAGE_CONFIG, IMAGE_LOADER, NgOptimizedImage, PRECONNECT_CHECK_BLOCKLIST, provideCloudflareLoader, provideCloudinaryLoader, provideImageKitLoader, provideImgixLoader, provideNetlifyLoader, } from './directives/ng_optimized_image';
export { normalizeQueryParams as ɵnormalizeQueryParams } from './location/util';
//# sourceMappingURL=data:application/json;base64,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