/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as o from './output_ast';
export function mapEntry(key, value) {
    return { key, value, quoted: false };
}
export function mapLiteral(obj, quoted = false) {
    return o.literalMap(Object.keys(obj).map((key) => ({
        key,
        quoted,
        value: obj[key],
    })));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFwX3V0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb21waWxlci9zcmMvb3V0cHV0L21hcF91dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUVILE9BQU8sS0FBSyxDQUFDLE1BQU0sY0FBYyxDQUFDO0FBVWxDLE1BQU0sVUFBVSxRQUFRLENBQUMsR0FBVyxFQUFFLEtBQW1CO0lBQ3ZELE9BQU8sRUFBQyxHQUFHLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUMsQ0FBQztBQUNyQyxDQUFDO0FBRUQsTUFBTSxVQUFVLFVBQVUsQ0FDeEIsR0FBa0MsRUFDbEMsU0FBa0IsS0FBSztJQUV2QixPQUFPLENBQUMsQ0FBQyxVQUFVLENBQ2pCLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdCLEdBQUc7UUFDSCxNQUFNO1FBQ04sS0FBSyxFQUFFLEdBQUcsQ0FBQyxHQUFHLENBQUM7S0FDaEIsQ0FBQyxDQUFDLENBQ0osQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0ICogYXMgbyBmcm9tICcuL291dHB1dF9hc3QnO1xuXG5leHBvcnQgdHlwZSBNYXBFbnRyeSA9IHtcbiAga2V5OiBzdHJpbmc7XG4gIHF1b3RlZDogYm9vbGVhbjtcbiAgdmFsdWU6IG8uRXhwcmVzc2lvbjtcbn07XG5cbmV4cG9ydCB0eXBlIE1hcExpdGVyYWwgPSBNYXBFbnRyeVtdO1xuXG5leHBvcnQgZnVuY3Rpb24gbWFwRW50cnkoa2V5OiBzdHJpbmcsIHZhbHVlOiBvLkV4cHJlc3Npb24pOiBNYXBFbnRyeSB7XG4gIHJldHVybiB7a2V5LCB2YWx1ZSwgcXVvdGVkOiBmYWxzZX07XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBtYXBMaXRlcmFsKFxuICBvYmo6IHtba2V5OiBzdHJpbmddOiBvLkV4cHJlc3Npb259LFxuICBxdW90ZWQ6IGJvb2xlYW4gPSBmYWxzZSxcbik6IG8uRXhwcmVzc2lvbiB7XG4gIHJldHVybiBvLmxpdGVyYWxNYXAoXG4gICAgT2JqZWN0LmtleXMob2JqKS5tYXAoKGtleSkgPT4gKHtcbiAgICAgIGtleSxcbiAgICAgIHF1b3RlZCxcbiAgICAgIHZhbHVlOiBvYmpba2V5XSxcbiAgICB9KSksXG4gICk7XG59XG4iXX0=