/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { OpKind } from '../enums';
import { TRAIT_CONSUMES_VARS } from '../traits';
import { NEW_OP } from './shared';
export function createHostPropertyOp(name, expression, isAnimationTrigger, i18nContext, securityContext, sourceSpan) {
    return {
        kind: OpKind.HostProperty,
        name,
        expression,
        isAnimationTrigger,
        i18nContext,
        securityContext,
        sanitizer: null,
        sourceSpan,
        ...TRAIT_CONSUMES_VARS,
        ...NEW_OP,
    };
}
//# sourceMappingURL=data:application/json;base64,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