/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Marker symbol for `ConsumesSlotOpTrait`.
 */
export const ConsumesSlot = Symbol('ConsumesSlot');
/**
 * Marker symbol for `DependsOnSlotContextOpTrait`.
 */
export const DependsOnSlotContext = Symbol('DependsOnSlotContext');
/**
 * Marker symbol for `ConsumesVars` trait.
 */
export const ConsumesVarsTrait = Symbol('ConsumesVars');
/**
 * Marker symbol for `UsesVarOffset` trait.
 */
export const UsesVarOffset = Symbol('UsesVarOffset');
/**
 * Default values for most `ConsumesSlotOpTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_SLOT = {
    [ConsumesSlot]: true,
    numSlotsUsed: 1,
};
/**
 * Default values for most `DependsOnSlotContextOpTrait` fields (used with the spread operator to
 * initialize implementors of the trait).
 */
export const TRAIT_DEPENDS_ON_SLOT_CONTEXT = {
    [DependsOnSlotContext]: true,
};
/**
 * Default values for `UsesVars` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_VARS = {
    [ConsumesVarsTrait]: true,
};
/**
 * Test whether an operation implements `ConsumesSlotOpTrait`.
 */
export function hasConsumesSlotTrait(op) {
    return op[ConsumesSlot] === true;
}
export function hasDependsOnSlotContextTrait(value) {
    return value[DependsOnSlotContext] === true;
}
export function hasConsumesVarsTrait(value) {
    return value[ConsumesVarsTrait] === true;
}
/**
 * Test whether an expression implements `UsesVarOffsetTrait`.
 */
export function hasUsesVarOffsetTrait(expr) {
    return expr[UsesVarOffset] === true;
}
//# sourceMappingURL=data:application/json;base64,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