/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as o from '../../../output/output_ast';
import * as ir from '../ir';
export const BINARY_OPERATORS = new Map([
    ['&&', o.BinaryOperator.And],
    ['>', o.BinaryOperator.Bigger],
    ['>=', o.BinaryOperator.BiggerEquals],
    ['|', o.BinaryOperator.BitwiseOr],
    ['&', o.BinaryOperator.BitwiseAnd],
    ['/', o.BinaryOperator.Divide],
    ['==', o.BinaryOperator.Equals],
    ['===', o.BinaryOperator.Identical],
    ['<', o.BinaryOperator.Lower],
    ['<=', o.BinaryOperator.LowerEquals],
    ['-', o.BinaryOperator.Minus],
    ['%', o.BinaryOperator.Modulo],
    ['*', o.BinaryOperator.Multiply],
    ['!=', o.BinaryOperator.NotEquals],
    ['!==', o.BinaryOperator.NotIdentical],
    ['??', o.BinaryOperator.NullishCoalesce],
    ['||', o.BinaryOperator.Or],
    ['+', o.BinaryOperator.Plus],
]);
export function namespaceForKey(namespacePrefixKey) {
    const NAMESPACES = new Map([
        ['svg', ir.Namespace.SVG],
        ['math', ir.Namespace.Math],
    ]);
    if (namespacePrefixKey === null) {
        return ir.Namespace.HTML;
    }
    return NAMESPACES.get(namespacePrefixKey) ?? ir.Namespace.HTML;
}
export function keyForNamespace(namespace) {
    const NAMESPACES = new Map([
        ['svg', ir.Namespace.SVG],
        ['math', ir.Namespace.Math],
    ]);
    for (const [k, n] of NAMESPACES.entries()) {
        if (n === namespace) {
            return k;
        }
    }
    return null; // No namespace prefix for HTML
}
export function prefixWithNamespace(strippedTag, namespace) {
    if (namespace === ir.Namespace.HTML) {
        return strippedTag;
    }
    return `:${keyForNamespace(namespace)}:${strippedTag}`;
}
export function literalOrArrayLiteral(value) {
    if (Array.isArray(value)) {
        return o.literalArr(value.map(literalOrArrayLiteral));
    }
    return o.literal(value);
}
//# sourceMappingURL=data:application/json;base64,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