/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export const Attribute = {
    /**
     * The jsaction attribute defines a mapping of a DOM event to a
     * generic event (aka jsaction), to which the actual event handlers
     * that implement the behavior of the application are bound. The
     * value is a semicolon separated list of colon separated pairs of
     * an optional DOM event name and a jsaction name. If the optional
     * DOM event name is omitted, 'click' is assumed. The jsaction names
     * are dot separated pairs of a namespace and a simple jsaction
     * name.
     *
     * See grammar in README.md for expected syntax in the attribute value.
     */
    JSACTION: 'jsaction',
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0cmlidXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9wcmltaXRpdmVzL2V2ZW50LWRpc3BhdGNoL3NyYy9hdHRyaWJ1dGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsTUFBTSxDQUFDLE1BQU0sU0FBUyxHQUFHO0lBQ3ZCOzs7Ozs7Ozs7OztPQVdHO0lBQ0gsUUFBUSxFQUFFLFVBQW1CO0NBQzlCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuZXhwb3J0IGNvbnN0IEF0dHJpYnV0ZSA9IHtcbiAgLyoqXG4gICAqIFRoZSBqc2FjdGlvbiBhdHRyaWJ1dGUgZGVmaW5lcyBhIG1hcHBpbmcgb2YgYSBET00gZXZlbnQgdG8gYVxuICAgKiBnZW5lcmljIGV2ZW50IChha2EganNhY3Rpb24pLCB0byB3aGljaCB0aGUgYWN0dWFsIGV2ZW50IGhhbmRsZXJzXG4gICAqIHRoYXQgaW1wbGVtZW50IHRoZSBiZWhhdmlvciBvZiB0aGUgYXBwbGljYXRpb24gYXJlIGJvdW5kLiBUaGVcbiAgICogdmFsdWUgaXMgYSBzZW1pY29sb24gc2VwYXJhdGVkIGxpc3Qgb2YgY29sb24gc2VwYXJhdGVkIHBhaXJzIG9mXG4gICAqIGFuIG9wdGlvbmFsIERPTSBldmVudCBuYW1lIGFuZCBhIGpzYWN0aW9uIG5hbWUuIElmIHRoZSBvcHRpb25hbFxuICAgKiBET00gZXZlbnQgbmFtZSBpcyBvbWl0dGVkLCAnY2xpY2snIGlzIGFzc3VtZWQuIFRoZSBqc2FjdGlvbiBuYW1lc1xuICAgKiBhcmUgZG90IHNlcGFyYXRlZCBwYWlycyBvZiBhIG5hbWVzcGFjZSBhbmQgYSBzaW1wbGUganNhY3Rpb25cbiAgICogbmFtZS5cbiAgICpcbiAgICogU2VlIGdyYW1tYXIgaW4gUkVBRE1FLm1kIGZvciBleHBlY3RlZCBzeW50YXggaW4gdGhlIGF0dHJpYnV0ZSB2YWx1ZS5cbiAgICovXG4gIEpTQUNUSU9OOiAnanNhY3Rpb24nIGFzIGNvbnN0LFxufTtcbiJdfQ==