/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { addEvents, createEarlyJsactionData, getQueuedEventInfos, registerDispatcher, removeAllEventListeners, } from './earlyeventcontract';
/**
 * Creates an `EarlyJsactionData`, adds events to it, and populates it on a nested object on
 * the window.
 */
export function bootstrapAppScopedEarlyEventContract(container, appId, bubbleEventTypes, captureEventTypes, dataContainer = window) {
    const earlyJsactionData = createEarlyJsactionData(container);
    if (!dataContainer._ejsas) {
        dataContainer._ejsas = {};
    }
    dataContainer._ejsas[appId] = earlyJsactionData;
    addEvents(earlyJsactionData, bubbleEventTypes);
    addEvents(earlyJsactionData, captureEventTypes, /* capture= */ true);
}
/** Get the queued `EventInfo` objects that were dispatched before a dispatcher was registered. */
export function getAppScopedQueuedEventInfos(appId, dataContainer = window) {
    return getQueuedEventInfos(dataContainer._ejsas?.[appId]);
}
/**
 * Registers a dispatcher function on the `EarlyJsactionData` present on the nested object on the
 * window.
 */
export function registerAppScopedDispatcher(restriction, appId, dispatcher, dataContainer = window) {
    registerDispatcher(dataContainer._ejsas?.[appId], dispatcher);
}
/** Removes all event listener handlers. */
export function removeAllAppScopedEventListeners(appId, dataContainer = window) {
    removeAllEventListeners(dataContainer._ejsas?.[appId]);
}
/** Clear the early event contract. */
export function clearAppScopedEarlyEventContract(appId, dataContainer = window) {
    if (!dataContainer._ejsas) {
        return;
    }
    dataContainer._ejsas[appId] = undefined;
}
//# sourceMappingURL=data:application/json;base64,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