/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { addEvents, createEarlyJsactionData, getQueuedEventInfos, registerDispatcher, removeAllEventListeners, } from './earlyeventcontract';
/** Creates an `EarlyJsactionData`, adds events to it, and populates it on the window. */
export function bootstrapGlobalEarlyEventContract(bubbleEventTypes, captureEventTypes) {
    const earlyJsactionData = createEarlyJsactionData(window.document.documentElement);
    addEvents(earlyJsactionData, bubbleEventTypes);
    addEvents(earlyJsactionData, captureEventTypes, /* capture= */ true);
    window._ejsa = earlyJsactionData;
}
/** Get the queued `EventInfo` objects that were dispatched before a dispatcher was registered. */
export function getGlobalQueuedEventInfos() {
    return getQueuedEventInfos(window._ejsa);
}
/** Registers a dispatcher function on the `EarlyJsactionData` present on the window. */
export function registerGlobalDispatcher(restriction, dispatcher) {
    registerDispatcher(window._ejsa, dispatcher);
}
/** Removes all event listener handlers. */
export function removeAllGlobalEventListeners() {
    removeAllEventListeners(window._ejsa);
}
/** Removes the global early event contract. */
export function clearGlobalEarlyEventContract() {
    window._ejsa = undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYm9vdHN0cmFwX2dsb2JhbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvcHJpbWl0aXZlcy9ldmVudC1kaXNwYXRjaC9zcmMvYm9vdHN0cmFwX2dsb2JhbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFHSCxPQUFPLEVBQ0wsU0FBUyxFQUNULHVCQUF1QixFQUN2QixtQkFBbUIsRUFDbkIsa0JBQWtCLEVBQ2xCLHVCQUF1QixHQUN4QixNQUFNLHNCQUFzQixDQUFDO0FBRzlCLHlGQUF5RjtBQUN6RixNQUFNLFVBQVUsaUNBQWlDLENBQy9DLGdCQUEwQixFQUMxQixpQkFBMkI7SUFFM0IsTUFBTSxpQkFBaUIsR0FBRyx1QkFBdUIsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ25GLFNBQVMsQ0FBQyxpQkFBaUIsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0lBQy9DLFNBQVMsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDckUsTUFBTSxDQUFDLEtBQUssR0FBRyxpQkFBaUIsQ0FBQztBQUNuQyxDQUFDO0FBRUQsa0dBQWtHO0FBQ2xHLE1BQU0sVUFBVSx5QkFBeUI7SUFDdkMsT0FBTyxtQkFBbUIsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDM0MsQ0FBQztBQUVELHdGQUF3RjtBQUN4RixNQUFNLFVBQVUsd0JBQXdCLENBQ3RDLFdBQXdCLEVBQ3hCLFVBQTBDO0lBRTFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDL0MsQ0FBQztBQUVELDJDQUEyQztBQUMzQyxNQUFNLFVBQVUsNkJBQTZCO0lBQzNDLHVCQUF1QixDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN4QyxDQUFDO0FBRUQsK0NBQStDO0FBQy9DLE1BQU0sVUFBVSw2QkFBNkI7SUFDM0MsTUFBTSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7QUFDM0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge1Jlc3RyaWN0aW9ufSBmcm9tICcuL3Jlc3RyaWN0aW9uJztcbmltcG9ydCB7XG4gIGFkZEV2ZW50cyxcbiAgY3JlYXRlRWFybHlKc2FjdGlvbkRhdGEsXG4gIGdldFF1ZXVlZEV2ZW50SW5mb3MsXG4gIHJlZ2lzdGVyRGlzcGF0Y2hlcixcbiAgcmVtb3ZlQWxsRXZlbnRMaXN0ZW5lcnMsXG59IGZyb20gJy4vZWFybHlldmVudGNvbnRyYWN0JztcbmltcG9ydCB7RXZlbnRJbmZvfSBmcm9tICcuL2V2ZW50X2luZm8nO1xuXG4vKiogQ3JlYXRlcyBhbiBgRWFybHlKc2FjdGlvbkRhdGFgLCBhZGRzIGV2ZW50cyB0byBpdCwgYW5kIHBvcHVsYXRlcyBpdCBvbiB0aGUgd2luZG93LiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGJvb3RzdHJhcEdsb2JhbEVhcmx5RXZlbnRDb250cmFjdChcbiAgYnViYmxlRXZlbnRUeXBlczogc3RyaW5nW10sXG4gIGNhcHR1cmVFdmVudFR5cGVzOiBzdHJpbmdbXSxcbikge1xuICBjb25zdCBlYXJseUpzYWN0aW9uRGF0YSA9IGNyZWF0ZUVhcmx5SnNhY3Rpb25EYXRhKHdpbmRvdy5kb2N1bWVudC5kb2N1bWVudEVsZW1lbnQpO1xuICBhZGRFdmVudHMoZWFybHlKc2FjdGlvbkRhdGEsIGJ1YmJsZUV2ZW50VHlwZXMpO1xuICBhZGRFdmVudHMoZWFybHlKc2FjdGlvbkRhdGEsIGNhcHR1cmVFdmVudFR5cGVzLCAvKiBjYXB0dXJlPSAqLyB0cnVlKTtcbiAgd2luZG93Ll9lanNhID0gZWFybHlKc2FjdGlvbkRhdGE7XG59XG5cbi8qKiBHZXQgdGhlIHF1ZXVlZCBgRXZlbnRJbmZvYCBvYmplY3RzIHRoYXQgd2VyZSBkaXNwYXRjaGVkIGJlZm9yZSBhIGRpc3BhdGNoZXIgd2FzIHJlZ2lzdGVyZWQuICovXG5leHBvcnQgZnVuY3Rpb24gZ2V0R2xvYmFsUXVldWVkRXZlbnRJbmZvcygpIHtcbiAgcmV0dXJuIGdldFF1ZXVlZEV2ZW50SW5mb3Mod2luZG93Ll9lanNhKTtcbn1cblxuLyoqIFJlZ2lzdGVycyBhIGRpc3BhdGNoZXIgZnVuY3Rpb24gb24gdGhlIGBFYXJseUpzYWN0aW9uRGF0YWAgcHJlc2VudCBvbiB0aGUgd2luZG93LiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJlZ2lzdGVyR2xvYmFsRGlzcGF0Y2hlcihcbiAgcmVzdHJpY3Rpb246IFJlc3RyaWN0aW9uLFxuICBkaXNwYXRjaGVyOiAoZXZlbnRJbmZvOiBFdmVudEluZm8pID0+IHZvaWQsXG4pIHtcbiAgcmVnaXN0ZXJEaXNwYXRjaGVyKHdpbmRvdy5fZWpzYSwgZGlzcGF0Y2hlcik7XG59XG5cbi8qKiBSZW1vdmVzIGFsbCBldmVudCBsaXN0ZW5lciBoYW5kbGVycy4gKi9cbmV4cG9ydCBmdW5jdGlvbiByZW1vdmVBbGxHbG9iYWxFdmVudExpc3RlbmVycygpIHtcbiAgcmVtb3ZlQWxsRXZlbnRMaXN0ZW5lcnMod2luZG93Ll9lanNhKTtcbn1cblxuLyoqIFJlbW92ZXMgdGhlIGdsb2JhbCBlYXJseSBldmVudCBjb250cmFjdC4gKi9cbmV4cG9ydCBmdW5jdGlvbiBjbGVhckdsb2JhbEVhcmx5RXZlbnRDb250cmFjdCgpIHtcbiAgd2luZG93Ll9lanNhID0gdW5kZWZpbmVkO1xufVxuIl19