/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Merge multiple application configurations from left to right.
 *
 * @param configs Two or more configurations to be merged.
 * @returns A merged [ApplicationConfig](api/core/ApplicationConfig).
 *
 * @publicApi
 */
export function mergeApplicationConfig(...configs) {
    return configs.reduce((prev, curr) => {
        return Object.assign(prev, curr, { providers: [...prev.providers, ...curr.providers] });
    }, { providers: [] });
}
//# sourceMappingURL=data:application/json;base64,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