/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { SIGNAL_NODE, signalSetFn } from '@angular/core/primitives/signals';
export const REQUIRED_UNSET_VALUE = /* @__PURE__ */ Symbol('InputSignalNode#UNSET');
// Note: Using an IIFE here to ensure that the spread assignment is not considered
// a side-effect, ending up preserving `COMPUTED_NODE` and `REACTIVE_NODE`.
// TODO: remove when https://github.com/evanw/esbuild/issues/3392 is resolved.
export const INPUT_SIGNAL_NODE = /* @__PURE__ */ (() => {
    return {
        ...SIGNAL_NODE,
        transformFn: undefined,
        applyValueToInputSignal(node, value) {
            signalSetFn(node, value);
        },
    };
})();
//# sourceMappingURL=data:application/json;base64,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