/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { assertInInjectionContext } from '../../di';
import { REQUIRED_UNSET_VALUE } from '../input/input_signal_node';
import { createModelSignal } from './model_signal';
export function modelFunction(initialValue) {
    ngDevMode && assertInInjectionContext(model);
    return createModelSignal(initialValue);
}
export function modelRequiredFunction() {
    ngDevMode && assertInInjectionContext(model);
    return createModelSignal(REQUIRED_UNSET_VALUE);
}
/**
 * `model` declares a writeable signal that is exposed as an input/output
 * pair on the containing directive.
 *
 * The input name is taken either from the class member or from the `alias` option.
 * The output name is generated by taking the input name and appending `Change`.
 *
 * @usageNotes
 *
 * To use `model()`, import the function from `@angular/core`.
 *
 * ```
 * import {model} from '@angular/core`;
 * ```
 *
 * Inside your component, introduce a new class member and initialize
 * it with a call to `model` or `model.required`.
 *
 * ```ts
 * @Directive({
 *   ...
 * })
 * export class MyDir {
 *   firstName = model<string>();            // ModelSignal<string|undefined>
 *   lastName  = model.required<string>();   // ModelSignal<string>
 *   age       = model(0);                   // ModelSignal<number>
 * }
 * ```
 *
 * Inside your component template, you can display the value of a `model`
 * by calling the signal.
 *
 * ```html
 * <span>{{firstName()}}</span>
 * ```
 *
 * Updating the `model` is equivalent to updating a writable signal.
 *
 * ```ts
 * updateName(newFirstName: string): void {
 *   this.firstName.set(newFirstName);
 * }
 * ```
 *
 * @developerPreview
 * @initializerApiFunction
 */
export const model = (() => {
    // Note: This may be considered a side-effect, but nothing will depend on
    // this assignment, unless this `model` constant export is accessed. It's a
    // self-contained side effect that is local to the user facing `model` export.
    modelFunction.required = modelRequiredFunction;
    return modelFunction;
})();
//# sourceMappingURL=data:application/json;base64,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