/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '../../di/injection_token';
/**
 * Injectable that is notified when an `LView` is made aware of changes to application state.
 */
export class ChangeDetectionScheduler {
}
/** Token used to indicate if zoneless was enabled via provideZonelessChangeDetection(). */
export const ZONELESS_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'Zoneless enabled' : '', { providedIn: 'root', factory: () => false });
/** Token used to indicate `provideExperimentalZonelessChangeDetection` was used. */
export const PROVIDED_ZONELESS = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'Zoneless provided' : '', { providedIn: 'root', factory: () => false });
export const ZONELESS_SCHEDULER_DISABLED = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'scheduler disabled' : '');
//# sourceMappingURL=data:application/json;base64,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