/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point from which you should import all public core APIs.
 */
export * from './authoring';
// Authoring functions are exported separately as this file is exempted from
// JSCompiler's conformance requirement for inferred const exports. See:
// https://docs.google.com/document/d/1RXb1wYwsbJotO1KBgSDsAtKpduGmIHod9ADxuXcAvV4/edit?tab=t.0
export { input } from './authoring/input/input';
export { contentChild, contentChildren, viewChild, viewChildren } from './authoring/queries';
export { model } from './authoring/model/model';
export * from './metadata';
export * from './version';
export * from './di';
export { ApplicationRef, NgProbeToken, APP_BOOTSTRAP_LISTENER, } from './application/application_ref';
export { PlatformRef } from './platform/platform_ref';
export { createPlatform, createPlatformFactory, assertPlatform, destroyPlatform, getPlatform, } from './platform/platform';
export { provideZoneChangeDetection, } from './change_detection/scheduling/ng_zone_scheduling';
export { provideExperimentalZonelessChangeDetection } from './change_detection/scheduling/zoneless_scheduling_impl';
export { ExperimentalPendingTasks } from './pending_tasks';
export { provideExperimentalCheckNoChangesForDebug } from './change_detection/scheduling/exhaustive_check_no_changes';
export { enableProdMode, isDevMode } from './util/is_dev_mode';
export { APP_ID, PACKAGE_ROOT_URL, PLATFORM_INITIALIZER, PLATFORM_ID, ANIMATION_MODULE_TYPE, CSP_NONCE, } from './application/application_tokens';
export { APP_INITIALIZER, ApplicationInitStatus } from './application/application_init';
export * from './zone';
export * from './render';
export * from './linker';
export * from './linker/ng_module_factory_loader_impl';
export { DebugElement, DebugEventListener, DebugNode, asNativeElements, getDebugNode, } from './debug/debug_node';
export { Testability, TestabilityRegistry, setTestabilityGetter, } from './testability/testability';
export * from './change_detection';
export * from './platform/platform_core_providers';
export { TRANSLATIONS, TRANSLATIONS_FORMAT, LOCALE_ID, DEFAULT_CURRENCY_CODE, MissingTranslationStrategy, } from './i18n/tokens';
export { ApplicationModule } from './application/application_module';
export { Type } from './interface/type';
export { EventEmitter } from './event_emitter';
export { ErrorHandler } from './error_handler';
export * from './core_private_export';
export * from './core_render3_private_export';
export * from './core_reactivity_export';
export { SecurityContext } from './sanitization/security';
export { Sanitizer } from './sanitization/sanitizer';
export { createNgModule, createNgModuleRef, createEnvironmentInjector, } from './render3/ng_module_ref';
export { createComponent, reflectComponentType } from './render3/component';
export { isStandalone } from './render3/definition';
export { AfterRenderPhase, afterRender, afterNextRender, } from './render3/after_render_hooks';
export { mergeApplicationConfig } from './application/application_config';
export { makeStateKey, TransferState } from './transfer_state';
export { booleanAttribute, numberAttribute } from './util/coercion';
import { global } from './util/global';
if (typeof ngDevMode !== 'undefined' && ngDevMode) {
    // This helper is to give a reasonable error message to people upgrading to v9 that have not yet
    // installed `@angular/localize` in their app.
    // tslint:disable-next-line: no-toplevel-property-access
    global.$localize ??= function () {
        throw new Error('It looks like your application or one of its dependencies is using i18n.\n' +
            'Angular 9 introduced a global `$localize()` function that needs to be loaded.\n' +
            'Please run `ng add @angular/localize` from the Angular CLI.\n' +
            "(For non-CLI projects, add `import '@angular/localize/init';` to your `polyfills.ts` file.\n" +
            'For server-side rendering applications add the import to your `main.server.ts` file.)');
    };
}
//# sourceMappingURL=data:application/json;base64,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