/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Describes the state of defer block dependency loading.
 */
export var DeferDependenciesLoadingState;
(function (DeferDependenciesLoadingState) {
    /** Initial state, dependency loading is not yet triggered */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["NOT_STARTED"] = 0] = "NOT_STARTED";
    /** Dependency loading is in progress */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["IN_PROGRESS"] = 1] = "IN_PROGRESS";
    /** Dependency loading has completed successfully */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["COMPLETE"] = 2] = "COMPLETE";
    /** Dependency loading has failed */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["FAILED"] = 3] = "FAILED";
})(DeferDependenciesLoadingState || (DeferDependenciesLoadingState = {}));
/** Slot index where `minimum` parameter value is stored. */
export const MINIMUM_SLOT = 0;
/** Slot index where `after` parameter value is stored. */
export const LOADING_AFTER_SLOT = 1;
/**
 * Describes the current state of this defer block instance.
 *
 * @publicApi
 */
export var DeferBlockState;
(function (DeferBlockState) {
    /** The placeholder block content is rendered */
    DeferBlockState[DeferBlockState["Placeholder"] = 0] = "Placeholder";
    /** The loading block content is rendered */
    DeferBlockState[DeferBlockState["Loading"] = 1] = "Loading";
    /** The main content block content is rendered */
    DeferBlockState[DeferBlockState["Complete"] = 2] = "Complete";
    /** The error block content is rendered */
    DeferBlockState[DeferBlockState["Error"] = 3] = "Error";
})(DeferBlockState || (DeferBlockState = {}));
/**
 * Describes the initial state of this defer block instance.
 *
 * Note: this state is internal only and *must* be represented
 * with a number lower than any value in the `DeferBlockState` enum.
 */
export var DeferBlockInternalState;
(function (DeferBlockInternalState) {
    /** Initial state. Nothing is rendered yet. */
    DeferBlockInternalState[DeferBlockInternalState["Initial"] = -1] = "Initial";
})(DeferBlockInternalState || (DeferBlockInternalState = {}));
export const NEXT_DEFER_BLOCK_STATE = 0;
// Note: it's *important* to keep the state in this slot, because this slot
// is used by runtime logic to differentiate between LViews, LContainers and
// other types (see `isLView` and `isLContainer` functions). In case of defer
// blocks, this slot would always be a number.
export const DEFER_BLOCK_STATE = 1;
export const STATE_IS_FROZEN_UNTIL = 2;
export const LOADING_AFTER_CLEANUP_FN = 3;
export const TRIGGER_CLEANUP_FNS = 4;
export const PREFETCH_TRIGGER_CLEANUP_FNS = 5;
/**
 * Options for configuring defer blocks behavior.
 * @publicApi
 */
export var DeferBlockBehavior;
(function (DeferBlockBehavior) {
    /**
     * Manual triggering mode for defer blocks. Provides control over when defer blocks render
     * and which state they render.
     */
    DeferBlockBehavior[DeferBlockBehavior["Manual"] = 0] = "Manual";
    /**
     * Playthrough mode for defer blocks. This mode behaves like defer blocks would in a browser.
     * This is the default behavior in test environments.
     */
    DeferBlockBehavior[DeferBlockBehavior["Playthrough"] = 1] = "Playthrough";
})(DeferBlockBehavior || (DeferBlockBehavior = {}));
//# sourceMappingURL=data:application/json;base64,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