/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { EMPTY_ARRAY } from '../util/empty';
import { stringify } from '../util/stringify';
import { importProvidersFrom } from './provider_collection';
import { getNullInjector, R3Injector } from './r3_injector';
/**
 * Create a new `Injector` which is configured using a `defType` of `InjectorType<any>`s.
 */
export function createInjector(defType, parent = null, additionalProviders = null, name) {
    const injector = createInjectorWithoutInjectorInstances(defType, parent, additionalProviders, name);
    injector.resolveInjectorInitializers();
    return injector;
}
/**
 * Creates a new injector without eagerly resolving its injector types. Can be used in places
 * where resolving the injector types immediately can lead to an infinite loop. The injector types
 * should be resolved at a later point by calling `_resolveInjectorDefTypes`.
 */
export function createInjectorWithoutInjectorInstances(defType, parent = null, additionalProviders = null, name, scopes = new Set()) {
    const providers = [additionalProviders || EMPTY_ARRAY, importProvidersFrom(defType)];
    name = name || (typeof defType === 'object' ? undefined : stringify(defType));
    return new R3Injector(providers, parent || getNullInjector(), name || null, scopes);
}
//# sourceMappingURL=data:application/json;base64,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