/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * The `di` module provides dependency injection container services.
 */
export * from './metadata';
export { assertInInjectionContext, runInInjectionContext } from './contextual';
export { InjectFlags } from './interface/injector';
export { ɵɵdefineInjectable, defineInjectable, ɵɵdefineInjector, } from './interface/defs';
export { forwardRef, resolveForwardRef } from './forward_ref';
export { Injectable } from './injectable';
export { Injector } from './injector';
export { EnvironmentInjector } from './r3_injector';
export { importProvidersFrom, makeEnvironmentProviders, } from './provider_collection';
export { ENVIRONMENT_INITIALIZER } from './initializer_token';
export { ɵɵinject, inject, ɵɵinvalidFactoryDep } from './injector_compatibility';
export { INJECTOR } from './injector_token';
export { InjectionToken } from './injection_token';
export { HostAttributeToken } from './host_attribute_token';
export { HOST_TAG_NAME } from './host_tag_name_token';
//# sourceMappingURL=data:application/json;base64,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