/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeDecorator } from '../util/decorators';
import { compileInjectable } from './jit/injectable';
export { compileInjectable };
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Injectable = makeDecorator('Injectable', undefined, undefined, undefined, (type, meta) => compileInjectable(type, meta));
//# sourceMappingURL=data:application/json;base64,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